/*ADC should read values continuously at the end of each cycle
 *Data read from ADC should show then be fed to my hex display
 *
 * Ayman A. Talkani
 * Columbia University
 */

module lab1(input logic        CLOCK_50,
	        output logic       ADC_SCK,
            output logic       ADC_CONVST,
		    output logic       ADC_SDI,
		    input logic        ADC_SDO,
            output logic [6:0] HEX0, HEX1, HEX2,
            output logic [9:0] LEDR);

   logic [15:0]    clk_count = 15'd0;
   logic [11:0]    B = 12'hfff;
   logic [3:0]     write_pos = 4'd11;
   logic [11:0] out;
   
   //Rather than using parameters, we will be hardcoding the following values:
   //DATA_BITS_NUM		12
   //CMD_BITS_NUM		6

   //tWHCONV              3   // CONVST High Time, min 20 ns, this is for 60 ns since we have a 50 MHz clock
   //tCONV     			80 // tCONV: type 1.3 us, MAX 1.6 us. Assumed clk is 50mhz, we set to 80 for 1.6 us

   //tHCONVST             320 //here set 320 for holding time after last SCK

   //tCONVST_HIGH_START	0 	
   //tCONVST_HIGH_END  	3 //(`tCONVST_HIGH_START+`tWHCONV) 

   //tCLK_START 			80 //(`tCONVST_HIGH_START+`tCONV)
   //tCLK_END 	   		92 //(`tCLK_START+`DATA_BITS_NUM)

   //tDONE 	   			412 //(`tCLK_END+`tHCONVST)
   //tCONFIG_START		3 //(`tCONVST_HIGH_END) 	
   //tCONFIG_END  		85 //(`tCLK_START+`CMD_BITS_NUM - 1) 
   
   // Parameters for SDI configuration for pin 2(top-right next to Vcc) and GND.
   //parameter S_D          = 1,
   //          O_S          = 0,
   //          S1           = 0,
   //          S0           = 0;
   //          UNI          = 1;
   //          SLP          = 0;


   //Use this logic to check if the readings are done(after time tDONE has passed)
   logic read_ch_done;
   assign read_ch_done = (clk_count == 412)?1'b1:1'b0;

  //Add a clock counter to keep track of number of cycles uptil tDONE
   always @ (posedge CLOCK_50)	
   begin
	   if (clk_count < 15'd412) clk_count <= clk_count + 15'd1;
       else if (read_ch_done) begin 
		clk_count <= 0;
	end
   end

   // ADC_CONVST value determined according to timing diagram and timing parameters described above 
   assign ADC_CONVST = (clk_count >= 0 && clk_count < 3)?1'b1:1'b0;

   // ADC_SCK, which is basically going to be the same value as CLK from 80-91 counts, and 0 otherwise. This way we sample values on ADC using the same clock, instead of creating a separate one

   logic clk_enable; // must sync to clk in clk low
   always @ (negedge CLOCK_50)	 
   begin
	   if ((clk_count > 79 && clk_count < 92))
		   clk_enable <= 1'b1;
	   else
		   clk_enable <= 1'b0;
   end

   assign ADC_SCK = clk_enable?CLOCK_50:1'b0;
   
   //Here we start storing the values of the ADC_SDO pins in our B register, which stores the values serially one at a time. The output here is 12 bits, which is why we are storing them one bit at a time
   //with B register[write_pos]
   
   always @ (negedge CLOCK_50)	
   begin
	   if (clk_enable)
	   begin
		   B[write_pos] <= ADC_SDO;
		   write_pos <= write_pos - 1;
	   end
	else if (read_ch_done) write_pos <= 4'd11;
   end

   //Here we configure the ADC chip to be able to determine which pins we will be reading from(by selecting the channel), as well as the mode at which it should be read(unipolar, bipolar, sleep mode, etc)
   
   logic config_init;
   logic config_enable;
   logic config_done;
   logic [0:5] config_cmd;
   logic [2:0] sdi_index;

   assign config_init = (clk_count == 3)?1'b1:1'b0;	
   assign config_enable = (clk_count > 80 && clk_count <= 85)?1'b1:1'b0;	// > because this is negative edge triggle
   assign config_done = (clk_count > 85)?1'b1:1'b0;

   assign config_cmd = 6'b100010 ; //channel 0, uni mode, sleep disabled

   //As SDI is again taking the data serially, we are sending it our inputs one bit at a time
   always @(negedge CLOCK_50)	
   begin
	   if (config_init)
	   begin
		   ADC_SDI <= config_cmd[5];
		   sdi_index <= 4;
	   end
	   else if (config_enable)
	   begin
		   ADC_SDI <= config_cmd[sdi_index];
		   sdi_index <= sdi_index - 1;
	   end
	   else if (config_done)
		   ADC_SDI <= 1'b0;
   end
   
   //Finally, we are displaying our values on the Hex Display. Note that the ADC value seems to have an offset of 12'h719, and seems to be decrementing as the input voltage supplied is increased. In order 
   //to mitigate this, we have gotten rid of the offset and framed the voltage as shown below, which gives us very accurate values from our ADC in millivolts, and displays this in our hex display!
   
   assign out = 12'h719 - B;
   hex7seg(out[3:0], HEX0);
   hex7seg(out[7:4], HEX1);
   hex7seg(out[11:8],HEX2);

   assign LEDR[0] = B[0];
   assign LEDR[1] = B[1];
   assign LEDR[2] = B[2];
   assign LEDR[3] = B[3];
   assign LEDR[4] = B[4];
   assign LEDR[5] = B[5];
   assign LEDR[6] = B[6];
   assign LEDR[7] = B[7];
   
	       
endmodule
