module writeOCM(
	input	logic							clk, reset,
	input	logic							start_out,
	input	logic	[16: 0]					out_idx,
	input	logic	[3*3*16-1: 0]			feat_map_out,

	output	logic							finish_out,

	// On-Chip RAM 1 s1 (write)
	output logic	[ 7: 0]					ocm1_writedata,
	output logic	[16: 0]					ocm1_addr,
	output logic							ocm1_chip,
	output logic							ocm1_clk_enab,
	output logic							ocm1_write,
	
	output logic 	[15: 0]					count,

	// Debug
	output	logic	[ 2: 0]					debug_state
);

	// FSM
	logic [ 2: 0]	state;
	assign debug_state = state;
	parameter S0 = 0, S1 = 1, S2 = 2, S3 = 3, S4 = 4, S5 = 5;
	
	logic [16: 0]		addr_write = 0;		// to address memory write
	logic [ 4: 0]		n_written = 0;
	
	always @ (posedge clk) begin
		case (state)
			S0:	// Reset
				begin
					count = 0;
					addr_write = 0;
					ocm1_chip = 1;
				end
			S1:	// Wait for start signal
				begin
					ocm1_clk_enab = 0;
					ocm1_write = 0;
					n_written = 0;
					finish_out = 0;
					addr_write = out_idx;
				end
			S2: // Write to OCM
				begin
					ocm1_addr = addr_write;
					ocm1_chip = 1;
					ocm1_clk_enab = 1;
					ocm1_write = 1;
					ocm1_writedata = feat_map_out[n_written +: 8];
					
					addr_write = addr_write + 1;
					n_written = n_written + 1;
					count = count + 1;
				end
			S3:
				begin
					ocm1_clk_enab = 0;
					ocm1_write = 0;
					finish_out = 1;
				end
		endcase
	end
	
	// Determine the next state
	always @ (posedge clk or posedge reset) begin
		if (reset)
			begin
				state <= S0;
			end
		else
			case (state)
				S0:
					state <= S1;
				S1:
					if(start_out)
						state <= S2;
				S2:
					if(n_written >= 9*2-1)
						state <= S3;
				S3:
					if(~start_out)
						state <= S1;
			endcase
	end

endmodule

