module testEcho(
	input	logic						clk, reset,// enable,

	input	logic						in_dv,
	input	logic	[ 7: 0]				in_data,
	input	logic						in_finish,
	output	logic						out_dv,
	output	logic	[ 9: 0][ 7: 0]		out_data,

	output	logic	[ 3: 0]				debug1,
	output	logic	[ 3: 0]				debug2
);

	// FSM
	logic [ 2: 0]	state;
	parameter S0 = 0, S1 = 1, S2 = 2, S3 = 3, S4 = 4, S5 = 5;
	

	logic	[28*28*8-1:0] buf_in;
	
	// in_data -> buf
	logic [15:0]	index_input = 0;
	// buf -> out_data
	logic [15:0]	index_output = 0;

	logic [15:0]	fp_test_out;
	float_multi mu(
		.num1				(index_input),
		.num2				(index_output),
		.result				(fp_test_out),
	);

	assign debug1 = fp_test_out[3:0];
	assign debug2 = fp_test_out[7:4];

	always @ (posedge clk) begin
		case (state)
			S0:	// reset
				begin
					out_dv = 0;
					index_input = 0;
					index_output = 0;
				end
			S1: // OCM -> buf_in
				begin
					if(in_dv) begin
						out_dv = 0;
						buf_in[index_input +: 8] = in_data;
						index_input = index_input + 8;
					end
				end
			S2: // reset index
			// TODO: not needed
				begin
					index_input = 0;
				end
			S3: // buf_in -> out
				begin

					out_dv = 1;
					// out_data = buf_in[index_output +: 10];
					out_data[0][7:0] = buf_in[index_output+8*0	+:	8];
					out_data[1][7:0] = buf_in[index_output+8*1	+:	8];
					out_data[2][7:0] = buf_in[index_output+8*2	+:	8];
					out_data[3][7:0] = buf_in[index_output+8*3	+:	8];
					out_data[4][7:0] = buf_in[index_output+8*4	+:	8];
					out_data[5][7:0] = buf_in[index_output+8*5	+:	8];
					out_data[6][7:0] = buf_in[index_output+8*6	+:	8];
					out_data[7][7:0] = buf_in[index_output+8*7	+:	8];
					out_data[8][7:0] = buf_in[index_output+8*8	+:	8];
					out_data[9][7:0] = buf_in[index_output+8*9	+:	8];
					index_output = index_output + 80;
				end
			S4: // idle - wait for OCM read to finish (in_dv goes down)
				begin
					out_dv = 0;
					out_data = 0;
				end
		endcase
	end
	
	// Determine the next state
	always @ (posedge clk or posedge reset) begin
		if (reset)
			begin
				state <= S0;
				// debug1 <= 8;
				// debug2 <= 8;
			end
		else
			case (state)
				S0:
					begin
						// debug2 <= 0;
						state <= S1;
					end
				S1:
					begin
						// debug2 <= 1;
						if(index_input >= 28*28*8) begin
						// if(in_finish) begin
							state <= S2;
							// debug1 <= 1;
						end
					end
				S2:
					begin
						// debug2 <= 2;
						state <= S3;
					end
				S3:
					begin
						// debug2 <= 3;
						if(index_output >= 16*10*8) begin
							// debug1 <= 2;
							state <= S4;
						end
					end
				S4:
					begin
						// debug2 <= 4;
						if(!in_dv) begin
							// debug1 <= 3;
							state <= S0;
						end
					end
			endcase
	end

endmodule

