#include <iostream>
#include "VtbRWFeatureMap.h"
#include <verilated.h>
#include <verilated_vcd_c.h>

// #define DEBUG_OCM_RW

void printOCM(uint8_t* mem, int offset, int len) {
	for(int i = offset; i < offset+len; i++){
		printf("%02x ", *((unsigned char *)mem+i));
		if((i-9) % 10 == 0)
			printf("\n");
	}
}

void printFeatMap(unsigned int* mem, int offset, int len) {
  for(int i = offset; i < offset+len; i++){
		printf("%02x ", *((unsigned char *)mem+i));
		if((i-9) % 10 == 0)
			printf("\n");
	}
}

void cleanOCM(uint8_t* mem, size_t len) {
  for(size_t i = 0; i < len; i++) {
    mem[i] = 0;
  }
}

int main(int argc, const char ** argv, const char ** env) {
  Verilated::commandArgs(argc, argv);

  VtbRWFeatureMap * dut = new VtbRWFeatureMap;
  
  Verilated::traceEverOn(true);
  VerilatedVcdC * tfp = new VerilatedVcdC;
  dut->trace(tfp, 99);
  tfp->open("tbRWFeatureMap.vcd");

  dut->clk = 0;
  dut->reset = 0;
  
  dut->h2f_start = 0;
  dut->h2f_read_length = 0;
  dut->h2f_buf_offset = 0;

  dut->f2h_start = 0;
  dut->f2h_write_length = 0;
  dut->f2h_buf_offset = 0;


  uint8_t ocm0[] = {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21,
                   22, 23, 24, 25};
  // Simulate ocm read behavior: data come out next cycle
  int ocm0_nextcycle_index = -1;

  uint8_t ocm1[1000] = {0};

  int time = 0;
  
  enum TBProcess{h2f_1_start, h2f_1_end, h2f_2_start, h2f_2_end, f2h_1_start, f2h_1_end, f2h_2_start, f2h_2_end};
  int h2f_1_time = 100;
  int h2f_2_time = -1;
  int f2h_1_time = -1;
  int f2h_2_time = -1;
  TBProcess currentProcess = h2f_1_start;

  for ( ; time < 3000 ; time += 10) {
    // 50MHz Clock
    dut->clk = ((time % 20) >= 10) ? 1 : 0;
    // Mem
    if (dut->clk) {
      if (dut->ocm0_chip && dut->ocm0_clk_enab) {
        if (ocm0_nextcycle_index != -1) {
#ifdef DEBUG_OCM_RW
        printf("[DEBUG] ocm0[%d]->0x%02x\n", ocm0_nextcycle_index, dut->ocm0_readdata);
#endif
          dut->ocm0_readdata = ocm0[ocm0_nextcycle_index];
        }
      }
//       if (dut->ocm1_chip && dut->ocm1_clk_enab) {
// #ifdef DEBUG_OCM_RW
//         printf("[DEBUG] ocm1[%d]<-0x%02x\n", dut->ocm1_addr, dut->ocm1_writedata);
// #endif
//         ocm1[dut->ocm1_addr] = dut->ocm1_writedata;
//       }
    }
    // Initial reset
    if (time == 0) dut->reset = 1;
    if (time == 40) dut->reset = 0;

    // ------------------h2f_1--------------------------
    if (time == h2f_1_time) {
      dut->h2f_read_length = 10;
      dut->h2f_buf_offset = 0;
      dut->h2f_start = 1;
    }

    if (dut->h2f_finish && currentProcess == h2f_1_start) {
      printf("\nFeature Map after first write:\n");
      printFeatMap(dut->feat_map, 0, 50);
      currentProcess = h2f_1_end;
      dut->h2f_start = 0;
      h2f_2_time = time + 200;
    }

    // ------------------h2f_2--------------------------
    if (time == h2f_2_time) {
      currentProcess = h2f_2_start;
      dut->h2f_read_length = 20;
      dut->h2f_buf_offset = 10;
      dut->h2f_start = 1;
    }

    if (dut->h2f_finish && currentProcess == h2f_2_start) {
      printf("\nFeature Map after second write:\n");
      printFeatMap(dut->feat_map, 0, 50);
      currentProcess = h2f_2_end;
      dut->h2f_start = 0;
      f2h_1_time = time + 200;
    }

    // ------------------f2h_1--------------------------
    if (time == f2h_1_time) {
      currentProcess = f2h_1_start;
      dut->f2h_write_length = 20;
      dut->f2h_buf_offset = 0;
      dut->f2h_start = 1;
    }

    if (dut->f2h_finish && currentProcess == f2h_1_start) {
      currentProcess = f2h_1_end;
      dut->f2h_start = 0;
      f2h_2_time = time + 200;
      printf("\nOCM1 after first read:\n");
      printOCM(ocm1, 0, 20);
      cleanOCM(ocm1, 1000);
    }

    // ------------------f2h_2--------------------------
    if (time == f2h_2_time) {
      currentProcess = f2h_2_start;
      dut->f2h_write_length = 30;
      dut->f2h_buf_offset = 5;
      dut->f2h_start = 1;
    }

    if (dut->f2h_finish && currentProcess == f2h_2_start) {
      currentProcess = f2h_2_end;
      dut->f2h_start = 0;
      printf("\nOCM1 after second read:\n");
      printOCM(ocm1, 0, 30);
      cleanOCM(ocm1, 1000);
    }

    dut->eval();
    tfp->dump( time );

    // Mem
    if (dut->ocm0_chip && dut->ocm0_clk_enab) {
      ocm0_nextcycle_index = dut->ocm0_addr;
    }
  }


  tfp->close();
  delete tfp;

  dut->final();
  delete dut;

  return 0;
}
