module tbPipeline(
	input	logic						clk, reset,

	// Input from HPS
	input	logic						start,
	input	logic	[15: 0]				read_length,
	input	logic	[5: 0]				read_data_dim,

	// On-Chip RAM 0 s2 (read)
	input	logic	[ 7: 0]				ocm0_readdata,
	output	logic	[16: 0]				ocm0_addr,
	output	logic						ocm0_chip,
	output	logic						ocm0_clk_enab,

	// On-Chip RAM 1 s1 (write)
	output	logic	[ 7: 0]				ocm1_writedata,
	output	logic	[16: 0]				ocm1_addr,
	output	logic						ocm1_chip,
	output	logic						ocm1_clk_enab,
	output	logic						ocm1_write,

	// Output
	output	logic						finish,
	output	logic	[32*32*16-1: 0]		feat_map_out,

	// DEBUG
	output	logic	[32*32*16-1: 0]		feat_map_in,
	output	logic	[2:0]				read_state,
	output	logic	[2:0]				conv_state,
	output	logic	[2:0]				write_state,
	output	logic	[15: 0]				write_count
);

wire						in_data_ready;
wire	[5: 0]				in_data_dim;
wire						out_data_ready;
// DEBUG - uncomment
// wire	[32*32*16-1: 0]		feat_map_in;
wire	[(3*3+1)*16-1: 0]	weight_bias;

readFMPipeline rd(
	.clk						(clk),
	.reset						(reset),

	// Input from HPS
	.start						(start),
	.read_length				(read_length),
	.read_data_dim				(read_data_dim),

	// Output to pipeline
	.in_data_ready				(in_data_ready),
	.in_data_dim				(in_data_dim),
	.feat_map_in				(feat_map_in),
	.weight_bias				(weight_bias),

	// On-Chip RAM 0 s2 (read)
	.ocm0_readdata				(ocm0_readdata),
	.ocm0_addr					(ocm0_addr),
	.ocm0_chip					(ocm0_chip),
	.ocm0_clk_enab				(ocm0_clk_enab),

	// Debug
	.debug_state				(read_state)
);

conv cv(
	.clk						(clk),
	.reset						(reset),

	// Input from pipeline
	.in_data_ready				(in_data_ready),
	.in_data_dim				(in_data_dim),
	.feat_map_in				(feat_map_in),
	.weight_bias				(weight_bias),

    // Output to pipeline
	.out_data_ready				(out_data_ready),
	.feat_map_out				(feat_map_out),

	// Debug
	.debug_state				(conv_state)
);

writeFMPipeline wr(
	.clk						(clk),
	.reset						(reset),

	// Input from pipeline
	.out_data_ready				(out_data_ready),
	.feat_map_out				(feat_map_out),
	.read_length				(read_length),
	
	// Output to HPS
	.finish						(finish),

	// On-Chip RAM 1 s1 (write)
	.ocm1_writedata				(ocm1_writedata),
	.ocm1_addr					(ocm1_addr),
	.ocm1_chip					(ocm1_chip),
	.ocm1_clk_enab				(ocm1_clk_enab),
	.ocm1_write					(ocm1_write),

	// Debug
	.debug_state				(write_state),
	.count						(write_count)
);

endmodule
