module readImg(
	input	logic						clk, reset,

	// Input from HPS
	input	logic						start,
	input	logic	[15: 0]				read_length,
	input	logic	[31: 0]				buf_offset,

	// Output to HPS
	output	logic						finish,
	output	logic	[ 2: 0]				debug_state,

	// On-Chip RAM 0 s2 (read)
	input	logic	[ 7: 0]				ocm0_readdata,
	output	logic	[16: 0]				ocm0_addr,
	output	logic						ocm0_chip,
	output	logic						ocm0_clk_enab,

	// Output to pipeline
	// inout	logic	[32*32*64*16-1:0]	feat_map,
	output	logic	[10000-1:0]			feat_map,
	// inout	logic	[1000-1:0]			feat_map,
	output	logic						in_dv
);

	// FSM
	logic [ 2: 0]	state;
	assign debug_state = state;
	parameter S0 = 0, S1 = 1, S2 = 2, S3 = 3, S4 = 4;

	// For OCM Read
	logic [16: 0]	addr = 0;
	logic [15: 0]	read_counter = 0;


	always @ (posedge clk) begin
		case (state)
			S0:	// reset
				begin
					addr = 0;
					ocm0_clk_enab = 0;
					in_dv = 0;
					finish = 0;
				end
			S1:	// prepare to read
				begin
					read_counter = 0;
					
					ocm0_addr = addr;
					ocm0_chip = 1;
					ocm0_clk_enab = 1;
					
					addr = addr + 1;
				end
			S2:	// Read
				begin
					ocm0_addr = addr;
					ocm0_chip = 1;
					ocm0_clk_enab = 1;
					
					feat_map[(buf_offset + read_counter)*8 +: 8] = ocm0_readdata;
					
					in_dv = 1;
					addr = addr + 1;
					read_counter = read_counter + 1;
				end
			S3: // Read last cycle
				begin
					ocm0_addr = 0;
					ocm0_chip = 1;
					ocm0_clk_enab = 1;

					feat_map[(buf_offset + read_counter)*8 +: 8] = ocm0_readdata;

					in_dv = 1;
					read_counter = read_counter + 1;
				end
			S4:	// Finished, wait for start->0
				begin
					finish = 1;
					ocm0_clk_enab = 0;
					in_dv = 0;
				end
		endcase
	end

	// Determine the next state
	always @ (posedge clk or posedge reset) begin
		if (reset)
			begin
				state <= S0;
			end
		else
			case (state)
				S0:
					if(start)
						state <= S1;
				S1:
					state <= S2;
				S2:
					begin
						if(addr >= read_length - 1)
							state <= S3;
					end
				S3:
					state <= S4;
				S4:
					if(start == 0)
						state <= S0;

			endcase
	end

endmodule
