module Deflate
  ( deflate,
  )
where

import BitHelper (lenToBits, litToBits, distToBits)
import qualified Data.ByteString.Lazy as B
import LZ77 (MResult, lz77Compress)

deflate :: B.ByteString -> [Bool]
deflate input = translate $ lz77Compress input

dummyCompress :: B.ByteString -> [MResult]
dummyCompress input = map (\f -> Just (0,0,f)) (B.unpack input) ++ [Nothing]

translate :: [MResult] -> [Bool]
translate [] = error "empty results, shouldn't happen"
translate [Nothing] = replicate 7 False
translate (Just (l, d, c) : rs)
  | l == 0 = litToBits (fromIntegral c) ++ translate rs
  | otherwise = lenToBits (fromIntegral l) ++ distToBits (fromIntegral d) ++ translate rs
translate _ = error "this should not be possible"