#!/bin/bash

stack clean

echo "compiling hzip..."
stack build > /dev/null 2>&1
echo "hzip compiled"

base_array=("corpus/artificl/" "corpus/calgary/" "corpus/cantrbry/" "corpus/large/" "corpus/misc/")

for base in ${base_array[@]}
do
    echo $base
    files=`ls $base`
    echo $files
    for fname in $files
    do
        echo $fname
        ls -al $base$fname
        time stack run $base$fname
        mv $base$fname $base$fname-orig
        ls -al $base$fname.gz
        gunzip $base$fname.gz
        diff $base$fname $base$fname-orig > /dev/null 2>&1
        echo $?
        rm -f $base$fname-orig
        echo
    done
done