#!/usr/bin/python3

import filecmp
import os, time
import subprocess

corpus = "corpus"
subdir = os.listdir(corpus)

subdir.sort()

for dir in subdir:
    print(dir)
    c = corpus + "/" + dir
    files = os.listdir(c)
    files.sort()
    for f in files:
        res = [f]
        fname = c + "/" + f

        orig_size = os.path.getsize(fname)
        res.append(str(orig_size))

        stime = time.time()
        subprocess.run(["stack", "run", fname], stdout=subprocess.DEVNULL)
        ftime = time.time()

        new_size = os.path.getsize(fname + ".gz")
        res.append(str(new_size))

        ratio = (new_size / orig_size) * 100
        res.append("{:.3f} \%".format(ratio))

        subprocess.run(["mv", fname, fname + "-orig"],
                       stdout=subprocess.DEVNULL)
        subprocess.run(["gunzip", fname+".gz"])

        # res.append(str(filecmp.cmp(fname+"-orig", fname)))
        res.append("{:.3f}".format(ftime-stime))

        subprocess.run(["rm", "-f", fname + "-orig"])

        print(" & ".join(res) + " \\\\ ")
