module Main where

import Lib ( writeOut, parCompress, seqCompress )
import System.Environment (getArgs)
import System.IO.Error
  ( catchIOError
  , ioeGetFileName
  , isDoesNotExistError
  , isPermissionError
  , isUserError
  )

main :: IO ()
main = mainLogic `catchIOError` handler

mainLogic :: IO ()
mainLogic = do
  [filename] <- getArgs
  compressed <- parCompress filename
  writeOut (filename ++ ".gz") compressed
  return ()

handler :: IOError -> IO ()
handler e
  | isDoesNotExistError e = putStrLn $ fn ++ ": No such file or directory"
  | isPermissionError e = putStrLn $ fn ++ ": Permission denied"
  | isUserError e = putStrLn "Usage: ./hzip <filename>"
  | otherwise = ioError e
  where
    Just fn = ioeGetFileName e
