# YAX: Yet Another Cross Referencer

## Build using stack

stack setup
stack build

## Testing

Some sample C source code is provided in `./test/c-tests`. To check the result, run

```
stack exec yax-exe -- ./test/c-tests -p
```

You should see a simple query interface shows up:
```
stack exec yax-exe -- ./test/c-tests -p
Search symbol:

```

Enter the symbol you want to search, for example `st1`, you shall get:
```
Search symbol:
st1
Just [("./test/c-tests/struct.c",1,8,IdDecl)]
```

Note that the column number above(`8`) may be inconsistent with what you get
from your code editor because the size of the tab.

A large code base is provided in `./test/perf/tests`.

To test the sequential performance, you can run:
```
 stack exec yax-exe -- ./test/perf/tests -s
```

To test the parallel performance, you can run:
```
 stack exec yax-exe -- ./test/perf/tests -p
```

Since the results of the query is not pretty printed, querying the performance
tests may flush the console due to excessive output.
