{-# LANGUAGE BlockArguments #-}
module WordEmbPar
   (
      parCooccurenceMatrix,
   )
   where

import qualified WordEmbSeq as WES
import qualified Utils as U
import qualified Control.Parallel.Strategies as ST hiding(parMap)
import qualified Data.Text as T
import qualified Data.Vector as V
import qualified Data.Map as M

parCooccurenceMatrix :: Int -> [[T.Text]] -> M.Map T.Text Int -> Int -> M.Map (Int, Int) Int
parCooccurenceMatrix 0 corpus vocab window = WES.cooccurenceMatrix corpus vocab window
parCooccurenceMatrix d corpus vocab window = M.unionWith (+) m1 m2
   where
      (x,y) = splitAt ((length corpus) `div` 2) corpus
      m1 = ST.runEval $ ST.rpar (parCooccurenceMatrix (d-1) x vocab window)
      m2 = ST.runEval $ ST.rpar (parCooccurenceMatrix (d-1) y vocab window)
