module Main where

import qualified Lib as L
import qualified Trie as T
import Data.List()
import qualified Data.Map as Map
import Control.Monad()
import System.Environment(getArgs, getProgName)
import System.Exit(die)


main :: IO ()
main = do args <- getArgs
          pn <- getProgName
          case args of
            [corpus, method] -> do 
              wordList <- readFile corpus
              let ws = words wordList

              if method /= "linear" && method /= "parallel"
                then die "Invalid Method"
              else do
                let word_counts = if method == "parallel" then L.wordsToCountPar ws else L.wordsToCounts ws

                let root = T.populateTrie (T.TrieNode Map.empty 0 False) word_counts

                print "Please Enter Search Term below:"
                search <- getLine
                let searchNode = T.searchTrie search root ""
                let results = T.fanTriePar searchNode search 4

                putStrLn ""
                mapM_ (putStrLn . L.showPair) (L.topNWords 10 results)
            _ -> die $ "Usage: " ++ pn ++ " <corpus-path> <running-method linear|parallel>"