module Rastrigin
  ( function
  , domain ) where

{- | Rastrigin's function

See <https://en.wikipedia.org/wiki/Rastrigin_function>

Global minimum: rastrigin(0, 0) = 0
Bounds: -5.12 <= xi <= 5.12
-}
function :: [Double] -> Double
function p = 10 * n + sum inner
  where
    n = fromIntegral $ length p
    inner = map (\x -> x**2 - 10 * cos (2 * pi * x)) p

domain :: [(Double, Double)]
domain = [(-5.12, 5.12), (-5.12, 5.12)]
