module Particle
  ( Particle(..)
  , initSwarm
  , update
  ) where
import Control.DeepSeq

data Particle = Particle
  { velocity :: [Double] -- ^ Velocity at time i
  , posCurr  :: [Double] -- ^ Position at time i
  , posBest  :: [Double] -- ^ Best position upon time i
  , valCurr  :: Double   -- ^ Current value at time i
  , valMin   :: Double   -- ^ Minival value upon time i
  } deriving (Show)

instance NFData Particle where
  rnf (Particle v pC pB vC vMin) = rnf v `deepseq`
                                   rnf pC `deepseq`
                                   rnf pB `deepseq`
                                   rnf vC `deepseq`
                                   rnf vMin

initSwarm :: ([Double] -> Double) -> [[Double]] -> [[Double]] -> [Particle]
initSwarm fn = zipWith (\ p v ->
  Particle { velocity = v
           , posCurr = p
           , posBest = p
           , valCurr = fn p
           , valMin  = fn p })



update
  :: ([Double] -> Double) -- ^ Cost function
  -> [(Double, Double)]   -- ^ Cost function domain
  -> [Double]             -- ^ Current global optimal position
  -> Double               -- ^ Weight parameter
  -> Particle             -- ^ Particle to update
  -> Particle
update fn domain posGOpt weight part = Particle { velocity = v'
                                                , posCurr  = p''
                                                , posBest  = pb'
                                                , valCurr  = val
                                                , valMin   = min' }
  where
    [r1, r2] = [0.5, 0.5]
    c1 = 4.1 * weight
    c2 = 4.1 * (1-weight)
    d1 = map (*(c1*r1)) $ zipWith (-) (posBest part) (posCurr part) --cognitive
    d2 = map (*(c2*r2)) $ zipWith (-) posGOpt (posCurr part) --social
    wV = velocity part --inertia
    v' = zipWith3 (\x y z -> x + y + z) wV d1 d2
    p' = zipWith (+) v' $ posCurr part
    p'' = zipWith (\xi (lower, upper) -> min (max xi lower) upper) p' domain
    val = fn p''
    pb' = if val < valMin part then p'' else posBest part
    min' = if val < valMin part then val else valMin part
