
import Test.HUnit
import Test.Framework
import Test.Framework.Providers.HUnit
import Lib

dyingTromino::[Cell]
dyingTromino = [(0,0), (0,1), (1,2)]

dyingBoardTest::Assertion
dyingBoardTest = assertBool "Dying tromino state should die after 3 moves" (testLifeFunc dyingTromino parLife 3 [])

deadBoardTest::Assertion
deadBoardTest = assertBool "Dead state should remain dead" (testLifeFunc [] parLife 1 [])

stableBoardTest::Assertion
stableBoardTest = assertBool "Stable state should remain same" (testLifeFunc [(1,2), (2,1), (2,3), (3,2), (3,3)] parLife 1 [(1,2), (2,1), (2,3), (3,2), (3,3)])

main :: IO ()
main = defaultMainWithOpts
       [testCase "deadBoardTest" deadBoardTest,
       testCase "dyingBoardTest" dyingBoardTest,
       testCase "stableBoardTest" stableBoardTest
       ]
       mempty
