module Main where
import Graphs 
import System.Environment(getArgs)
import qualified Data.IntMap.Strict as IntMap
import Control.DeepSeq (force)

main :: IO()
main = do 
    args <- getArgs
    case args of
        [filename] -> do
            graph <- force readGraphDIMACS filename
            let initialK = IntMap.size graph
            print (searchK initialK graph)
        _ -> error "Bad Input"
