non_par_ver=("BF" "FFT" "FFTCT") # 
par_ver=("BFPAR" "FFTPAR" "FFTCTPAR" "BFMP") # 

test_non_parallel_small()
{
    for ver in "${non_par_ver[@]}"
    do
      echo $ver
      for (( i = 1000; i < 10000; i=i+1000 ));
      do
        # echo -e "$ver\ntest/test_input/$i.in\n0" > test/test_args/non-parallel/$ver$i
        echo -e "$ver\ntest/test_input/$i.in\n1" > test_args.in
        echo "$i.in"
        time stack exec multpoly-exe < test_args.in > temp
        
        # stack exec multpoly-exe -- +RTS -l < test_args.in
        # cp multpoly-exe.eventlog test/test_output/non-parallel/$ver$i.eventlog
      done
    done
}

test_non_parallel_large()
{
    for ver in "${non_par_ver[@]}"
    do
      for (( i = 60000; i <= 80000; i=i+10000 ));
      do
        echo -e "$ver\ntest/test_input/$i.in\n0" > test_args.in
        echo "$ver $i.in"
        time stack exec multpoly-exe < test_args.in > temp
      done
    done
}

test_mapreduce()
{
    ver="BFMP"
    for ((c = 8; c <= 8; c++ ));
    do
      for (( i = 1000; i < 4000; i=i+1000 ));
      do
        echo -e "$ver\ntest/test_input/$i.in\n$c" > test_args.in
        echo "$c cores $i.in"
        time stack exec multpoly-exe -- +RTS -l -N$c < test_args.in > temp
        # cp multpoly-exe.eventlog test/test_output/$ver$i.eventlog
      done
    done
}

test_parallel_1_small()
{
    for ver in "${par_ver[@]}"
    do
      for ((c = 1; c <= 8; c++ ));
      do
        for (( i = 1000; i <= 9000; i=i+1000 ));
        do
          echo "$ver $c cores $i.in"
          echo -e "$ver\ntest/test_input/$i.in\n$c" > test_args.in
          time stack exec multpoly-exe -- +RTS -l -N$c < test_args.in > temp
        done
      done
    done
}

test_parallel_1_large()
{
    for ver in "${par_ver[@]}"
    do
      for ((c = 4; c <= 4; c++ ));
      do
        for (( i = 60000; i <= 80000; i=i+10000 ));
        do
          echo "$ver $c cores $i.in"
          echo -e "$ver\ntest/test_input/$i.in\n$c" > test_args.in
          time stack exec multpoly-exe -- +RTS -N$c < test_args.in > temp
        done
      done
    done
}

test_parallel_depth()
{
    for ver in "${par_ver[@]}"
    do
      for (( i = 80000; i <= 80000; i=i+10000 ));
      do
        for ((d = 1; d <= 16; d++ ));
        do
          echo "$ver depth $d $i.in"
          echo -e "$ver\ntest/test_input/$i.in\n$d" > test_args.in
          time stack exec multpoly-exe -- +RTS -l -N8 < test_args.in > temp
        done
      done
    done
}

test_new_parallel()
{
    for ver in "${par_ver[@]}"
    do
      for (( i = 50000; i <= 80000; i=i+10000 ));
      do
          echo "$ver $i.in"
          echo -e "$ver\ntest/test_input/$i.in\n4" > test_args.in
          time stack exec multpoly-exe -- +RTS -N4 < test_args.in > temp
      done
    done
}

test_new_non_parallel()
{
    for ver in "${non_par_ver[@]}"
    do
      for (( i = 50000; i <= 80000; i=i+10000 ));
      do
          echo "$ver $i.in"
          echo -e "$ver\ntest/test_input/$i.in\n4" > test_args.in
          time stack exec multpoly-exe < test_args.in > temp
      done
    done
}

input=("1000" "10000")
test_example()
{
    for ver in "${par_ver[@]}"
    do
      for i in "${input[@]}" 
      do
          echo -e "$ver\ntest/test_input/$i.in\n2" > test/test_args/$ver$i\_2.in
          time stack exec multpoly-exe < test/test_args/$ver$i\_2.in > temp
      done
    done
}

test_example_()
{
    for ver in "${non_par_ver[@]}"
    do
      for i in "${input[@]}" 
      do
          echo -e "$ver\ntest/test_input/$i.in\n1" > test/test_args/$ver$i.in
          time stack exec multpoly-exe < test/test_args/$ver$i.in > temp
      done
    done

}

test_unbalanced()
{
    for ver in "${non_par_ver[@]}"
    do
          echo "$ver"
          echo -e "$ver\ntest/test_input/100_10000.in\n4" > test_args.in
          time stack exec multpoly-exe < test_args.in > temp
    done
}

test_unbalanced
