-- Brute Force Polynomial Multiplication in Parallelization with Par
module BruteForce.ParMultPoly
(
  mult_polys
) where

import BruteForce.MultPoly(mult_poly_num, add_polys)
import Control.Parallel.Strategies(rseq, rpar, runEval)
import Control.DeepSeq(force)

mult_polys :: Int -> [Double] -> [Double] -> [Double]
mult_polys 0 x y = foldr shift_add [0] $ map (mult_poly_num x) y
  where 
    shift_add a z = add_polys a (0 : z)
mult_polys d x y = runEval $ do
  a_prods <- rpar (force (mult_polys (d - 1) x ay))
  b_prods <- rpar (force (mult_polys (d - 1) x by))
  _ <- rseq a_prods
  _ <- rseq b_prods
  return $ add_polys a_prods ((take half_l $ repeat 0) ++ b_prods)
  where
    half_l = (length y) `div` 2
    (ay, by) = splitAt half_l y
    