-- stack build
-- stack exec multpoly-exe
-- stack exec multpoly-exe -- +RTS -l -N4
module Main where

import System.IO(Handle, hGetLine, stdin, getLine, readLn, openFile, IOMode(ReadMode))

import qualified BruteForce.MultPoly(mult_polys)
import qualified BruteForce.MapReduce(mult_polys)
import qualified BruteForce.ParMultPoly(mult_polys)
import qualified FFT.FMultPoly(mult_polys)
import qualified FFT.CTMultPoly(mult_polys)
import qualified FFT.ParFMultPoly(mult_polys)
import qualified FFT.ParCTMultPoly(mult_polys)

import Data.Complex

get_nums :: Handle -> IO [Double]
get_nums = to_nums . hGetLine
  where
    to_nums line = do
      line_str <- line
      return $ map read $ words line_str

get_int :: IO Int
get_int = readLn

mult_polys :: String -> Int -> [Double] -> [Double] -> [Double]
mult_polys "BF" _ x y = BruteForce.MultPoly.mult_polys x y  -- serial
mult_polys "BFMP" d x y = BruteForce.MapReduce.mult_polys d x y  -- parallel
mult_polys "BFPAR" d x y = BruteForce.ParMultPoly.mult_polys d x y -- parallel
mult_polys "FFT" _ x y = FFT.FMultPoly.mult_polys x y  -- serial
mult_polys "FFTCT" _ x y = FFT.CTMultPoly.mult_polys x y  -- serial
mult_polys "FFTPAR" d x y = FFT.ParFMultPoly.mult_polys d x y  -- parallel
mult_polys "FFTCTPAR" d x y = FFT.ParCTMultPoly.mult_polys d x y  -- parallel
mult_polys ver _ _ _ = error ("unknown version " ++ ver)

main :: IO ()
main = do
  _ <- putStrLn "version:"
  ver <- getLine
  _ <- putStrLn "input file path:"
  file_path <- getLine
  _ <- putStrLn "depth:"
  depth <- get_int
  handle <- System.IO.openFile file_path System.IO.ReadMode
  x <- get_nums handle
  y <- get_nums handle
  mapM_ print (mult_polys ver depth x y)
  -- putStrLn $ show $ length $ (mult_polys ver depth x y)
