# multpoly

There are seven different implementations of polynomial multiplications in this project.

1. BF: brute force algorithm (`src/BruteForce/MultPoly.hs`)
2. BFMP: brute force algorithm paralleled by Map Reduce (`src/BruteForce/MapReduce.hs`)
3. BFPAR: brute force algorithm paralleled by `rpar` (`src/BruteForce/ParMultPoly.hs`)
4. FFT: recursive fast fourier transform algorithm (`src/FFT/FMultPoly.hs`)
5. FFTPAR: parallel recursive fast fourier transform algorithm (`src/FFT/ParFMultPoly.hs`)
6. FFTCT: iterative fast fourier transform algorithm (`src/FFT/CTMultPoly.hs`)
7. FFTCTPAR: parallel iterative fast fourier transform algorithm (`src/FFT/ParCTMultPoly.hs`)

### Compilation & Usage

The program can be compiled by

```shell
stack build
```

It can be run with (single core)

```shell
stack exec multpoly-exe
```

or (multiple cores)

```shell
stack exec multpoly-exe -- +RTS -l -N4
```

The main program will prompt for three user inputs:

```
[version]
[input file]
[depth]
```

**version** specifies which implementation to use. It can only be one of `[BF, BFMP, BFPAR, FFT, FFTPAR, FFTCT, FFTCTPAR]`.

**input file** specifies the file storing two polynomials used for multiplication. Example input files are `.in` files under `test/test_input` directory, which also contains `gen_polys.cpp` that can generate random polynomials.

```shell
cd test/test_input
g++ gen_polys.cpp
./a.out [length of polynomial 1] [length of polynomial 2] > polynomial.in
```

**depth** specifies parallelization depth for parallel algorithms (`BFMP, BFPAR, FFTPAR, FFTCTPAR`). It should be greater than 0 for parallel algorithms; it is ignored for non-parallel algorithms (`BF, FFT, FFTCT`).

Below is an example input:

```
version:
FFT
input file path:
test/test_input/1000.in
depth:
1
```

For convenience, `test/test_args` stores some example inputs that can be passed to program using redirection in shell.

```shell
stack exec multpoly-exe -- +RTS -l -N2 < test/test_args/FFTPAR1000_2.in
```

