import Data.Heap
import System.Exit(die)
import Control.Monad
import Control.Parallel.Strategies

type Maze = [[Int]]

data Heap_item = Heap_item {
        distance :: Int,
        start_row :: Int,
        start_col :: Int,
        direction :: String
    } deriving (Eq, Ord, Show)


set_insert :: Eq a => a -> [a] -> [a]
set_insert x xs
    | not (x `elem` xs) = x:xs
    | otherwise         = xs


heaphead :: HeapT (Prio MinPolicy Heap_item) () -> Heap_item
heaphead heap = head (Data.Heap.take 1 heap)


main :: IO ()
main = do
    let maze = [[0,0,0,0,0],[1,1,0,0,1],[0,0,0,0,0],[0,1,0,0,1],[0,1,0,0,0]]
        ball = (4, 3)
        hole = (0, 1)
        heap_init = Heap_item 0 (fst ball) (snd ball) "start"
        heap = Data.Heap.fromList [heap_init] :: MinHeap Heap_item
        visited_nodes = []
    heap_output <- gameloop heap visited_nodes hole maze
    if isEmpty heap_output then
        putStrLn $ "Impossible to reach the hole!"
    else do
        let heap_head = heaphead heap_output
        putStrLn $ "Instruction: " ++ (direction heap_head) ++ "\nTotal distance: " ++ (show $ distance heap_head)


gameloop :: Monad m => HeapT (Prio MinPolicy Heap_item) () -> [(Int, Int)] -> (Int, Int) -> Maze -> m (HeapT (Prio MinPolicy Heap_item) ())
gameloop h visited_nodes hole maze = do
        if isEmpty h
            then return h
        else do
            let heap_head = heaphead h
                h_n = Data.Heap.drop 1 h
                current_distance = distance heap_head
                current_row = start_row heap_head
                current_col = start_col heap_head
                current_string = direction heap_head
            if ((current_row, current_col) == hole) then do
                let heap_final = Data.Heap.fromList [heap_head] :: MinHeap Heap_item
                return heap_final
            else do
                let visited_nodes_n = set_insert (current_row, current_col) visited_nodes
                h_d <- helper h_n maze hole visited_nodes_n current_distance current_row current_col current_string 1 0 "down"
                h_u <- helper h_d maze hole visited_nodes_n current_distance current_row current_col current_string (-1) 0 "up"
                h_r <- helper h_u maze hole visited_nodes_n current_distance current_row current_col current_string 0 1 "right"
                h_l <- helper h_r maze hole visited_nodes_n current_distance current_row current_col current_string 0 (-1) "left"
                gameloop h_l visited_nodes_n hole maze


helper :: Monad m => HeapT (Prio MinPolicy Heap_item) () -> Maze -> (Int, Int) -> [(Int, Int)] -> Int -> Int -> Int -> String -> Int -> Int -> String -> m (HeapT (Prio MinPolicy Heap_item) ())
helper heap maze hole visited_nodes current_distance current_row current_col current_string row_diff col_diff direction = do
    let result = move maze hole current_row current_col 0 row_diff col_diff
        row_n = first result
        col_n = second result
        count_n = third result
    if not ((row_n, col_n) `elem` visited_nodes) then do
        let heap_item_n = Heap_item (current_distance + count_n) row_n col_n (current_string ++ "->" ++ direction)
            h_n = Data.Heap.insert heap_item_n heap
        return h_n
    else do
        return heap


move :: Maze -> (Int, Int) -> Int -> Int -> Int -> Int -> Int -> (Int, Int, Int)
move maze hole row col count row_diff col_diff
  | ((row+row_diff) >= (maze_m maze)) || (row+row_diff) < 0 || ((col+col_diff) >= (maze_n maze)) || (col+col_diff) < 0 || ((maze!!(row+row_diff))!!(col+col_diff)) /= 0 = (row, col, count)
  | (row+row_diff, col+col_diff) == hole = (row+row_diff, col+col_diff, count+1)
  | otherwise = move maze hole (row+row_diff) (col+col_diff) (count+1) row_diff col_diff


first :: (a, b, c) -> a
first (a,_,_) = a

second :: (a, b, c) -> b
second (_,b,_) = b

third :: (a, b, c) -> c
third (_,_,c) = c

maze_m :: Maze -> Int
maze_m maze = length maze

maze_n :: Maze -> Int
maze_n maze = length $ head maze