import Data.Heap
import Control.Monad
import Control.DeepSeq
import Control.Parallel.Strategies

type Maze = [[Int]]

data Heap_item = Heap_item {
        distance :: Int,
        start_row :: Int,
        start_col :: Int,
        direction :: String
    } deriving (Eq, Ord, Show)


set_insert :: Eq a => a -> [a] -> [a]
set_insert x xs
    | not (x `elem` xs) = x:xs
    | otherwise         = xs


heaphead :: HeapT (Prio MinPolicy Heap_item) () -> Heap_item
heaphead heap = head (Data.Heap.take 1 heap)

maze_constructor :: Int -> Maze
maze_constructor n = ((p n 1 []) : (replicate (n-2) (odd_to_1 n 1 []))) ++ [q n 1 []]
  where
    odd_to_1 n i result
      | i > n = result
      | mod i 2 == 1 = odd_to_1 n (i+1) (result++[1])
      | otherwise = odd_to_1 n (i+1) (result++[0])
    p n i result
      | i > n = result
      | mod i 4 == 1 = p n (i+1) (result++[1])
      | otherwise = p n (i+1) (result++[0])
    q n i result
      | i > n = result
      | mod i 4 == 3 = q n (i+1) (result++[1])
      | otherwise = q n (i+1) (result++[0])

main :: IO ()
main = do
    let maze = maze_constructor 1000
        ball = (999, 999)
        hole = (999, 0)
        heap_init = Heap_item 0 (fst ball) (snd ball) "start"
        heap = Data.Heap.fromList [heap_init] :: MinHeap Heap_item
        visited_nodes = []
    heap_output <- gameloop heap visited_nodes hole maze
    if isEmpty heap_output then
        putStrLn $ "Impossible to reach the hole!"
    else do
        let heap_head = heaphead heap_output
        putStrLn $ "Instruction: " ++ (direction heap_head) ++ "\nTotal distance: " ++ (show $ distance heap_head)


gameloop :: Monad m => HeapT (Prio MinPolicy Heap_item) () -> [(Int, Int)] -> (Int, Int) -> Maze -> m (HeapT (Prio MinPolicy Heap_item) ())
gameloop h visited_nodes hole maze = do
        if isEmpty h
            then return h
        else do
            let heap_head = heaphead h
                h_n = Data.Heap.drop 1 h
                current_distance = distance heap_head
                current_row = start_row heap_head
                current_col = start_col heap_head
                current_string = direction heap_head
            if ((current_row, current_col) == hole) then do
                let heap_final = Data.Heap.fromList [heap_head] :: MinHeap Heap_item
                return heap_final
            else do
                let visited_nodes_n = set_insert (current_row, current_col) visited_nodes
                    ins = map (move maze hole current_row current_col 0) [(1,0), (-1,0), (0,1), (0,-1)] `using` parList rpar
                h_l <- helper h_n visited_nodes_n current_distance current_string ["down", "up", "right", "left"] ins
                gameloop h_l visited_nodes_n hole maze


helper :: Monad m => HeapT (Prio MinPolicy Heap_item) () -> [(Int, Int)] -> Int -> String -> [String] ->  [(Int, Int, Int)] -> m (HeapT (Prio MinPolicy Heap_item) ())
helper heap visited_nodes current_distance current_string direction instruction = do
    if Prelude.null instruction
        then return heap
    else do
        let i = head instruction
            row_n = first i
            col_n = second i
            count_n = third i
            d = head direction
        if not ((row_n, col_n) `elem` visited_nodes) then do
            let heap_item_n = Heap_item (current_distance + count_n) row_n col_n (current_string ++ "->" ++ d)
                h_n = Data.Heap.insert heap_item_n heap
            helper h_n visited_nodes current_distance current_string (Prelude.drop 1 direction) (Prelude.drop 1 instruction)
        else do
            helper heap visited_nodes current_distance current_string (Prelude.drop 1 direction) (Prelude.drop 1 instruction)


move :: Maze -> (Int, Int) -> Int -> Int -> Int -> (Int, Int) -> (Int, Int, Int)
move maze hole row col count (row_diff, col_diff)
  | ((row+row_diff) >= (maze_m maze)) || (row+row_diff) < 0 || ((col+col_diff) >= (maze_n maze)) || (col+col_diff) < 0 || ((maze!!(row+row_diff))!!(col+col_diff)) /= 0 = (row, col, count)
  | (row+row_diff, col+col_diff) == hole = (row+row_diff, col+col_diff, count+1)
  | otherwise = move maze hole (row+row_diff) (col+col_diff) (count+1) (row_diff, col_diff)


first :: (a, b, c) -> a
first (a,_,_) = a

second :: (a, b, c) -> b
second (_,b,_) = b

third :: (a, b, c) -> c
third (_,_,c) = c

maze_m :: Maze -> Int
maze_m maze = length maze

maze_n :: Maze -> Int
maze_n maze = length $ head maze