import Solver (solver, Square)
import qualified Data.List as L
import System.Environment(getArgs, getProgName)
import System.Exit(die)

prettyPrint :: Maybe Square -> IO()
prettyPrint (Just s) = putStrLn $ unlines $ L.map (unwords . L.map show) s
prettyPrint Nothing = putStrLn ""

parseHelper :: [String] -> [Int]
parseHelper (x:xs) = (read x :: Int) : parseHelper xs
parseHelper _ = []

parseInput :: [String] -> Square
parseInput (x:xs) = (parseHelper $ words x) : parseInput xs
parseInput _ = []

main :: IO ()
main = do
        args <- getArgs
        (filename) <- case args of
            [filename] -> return (filename)
            _ -> do pn <- getProgName
                    die $ "Usage: " ++ pn ++ " <filename> +RTS -N? -ls"
        file <- readFile filename
        let inputMagic = parseInput $ lines file
        mapM_ prettyPrint (solver inputMagic)
