
import seaborn as sns 
import matplotlib.pyplot as plt
import pandas as pd
import numpy as np
import pprint

import glob

# the quickest, dirtiest, and fugliest parsing scripts you've ever seen
###### Data Reading Section #######
out = {}
for run in ['Par+Base', 'Par+AB', 'Brothers']:
    for pd in range(0,8):
        # print(pd)
        for md in range(3,8):
            # print(md)

            fname = run+'-'+str(pd)+'-'+str(md)
            f = open(fname)
            if (run == 'Par+AB' and pd == 6 and md == 7):
                f = open(fname+'-new')
            if (run == 'Brothers' and (pd == 3) and md == 7):
                f = open(fname+'-new2')

            move_arr = []
            total_time_arr = []
            correct_time_arr = []

            while True:
                move = f.readline()
                time = f.readline()
                if not time:
                    break
                total_time_arr.append(float(time))
                if move != '0\n':
                    move_arr.append(int(move))
                    correct_time_arr.append(float(time))

            correct_time_avg = sum(correct_time_arr)/len(correct_time_arr)
            total_time_avg = sum(total_time_arr)/len(total_time_arr)
            move_avg = sum(move_arr)/len(move_arr)
            correctness = len(correct_time_arr)/len(total_time_arr)
            out[fname] = {
                'correct_time_avg': correct_time_avg,
                'total_time_avg': total_time_avg,
                'move_avg': move_avg,
                'correctness': correctness,
            }

for run in ['Base', 'AB']:
    for md in range(3,8):

        fname = run+'--'+str(md)
        f = open(fname)

        move_arr = []
        total_time_arr = []

        correct_time_arr = []

        while True:
            move = f.readline()
            time = f.readline()
            if not time:
                break
            total_time_arr.append(float(time))
            if move != '0\n':
                move_arr.append(int(move))
                correct_time_arr.append(float(time))

        correct_time_avg = sum(correct_time_arr)/len(correct_time_arr)
        total_time_avg = sum(total_time_arr)/len(total_time_arr)
        move_avg = sum(move_arr)/len(move_arr)
        correctness = len(correct_time_arr)/len(total_time_arr)
        out[fname] = {
            'correct_time_avg': correct_time_avg,
            'total_time_avg': total_time_avg,
            'move_avg': move_avg,
            'correctness': correctness,
        }

for run in ['Par+Base', 'Par+AB', 'Brothers']:
    for md in range(3,8):
        for pd in range(0,md):

            fname = run+'-'+str(pd)+'-'+str(md)
            f = open('threadstats-'+fname)

            percents_out = []
            while True:
                sparks = f.readline()
                if not sparks:
                    break
                total = int(sparks.split(" ")[3])
                converts = int(sparks.split(" ")[4][1:])
                percents_out.append(converts/total)

            percents_avg = sum(percents_out)/len(percents_out)
            out[fname]['percent_avg'] = percents_avg



for run in ['Par+Base', 'Par+AB', 'Brothers']:
    for core in range(2,8):

        fname = run+'-Core-'+str(core)
        f = open(fname)

        move_arr = []
        total_time_arr = []
        correct_time_arr = []

        while True:
            move = f.readline()
            time = f.readline()
            if not time:
                break
            total_time_arr.append(float(time))
            if move != '0\n':
                move_arr.append(int(move))
                correct_time_arr.append(float(time))

        correct_time_avg = sum(correct_time_arr)/len(correct_time_arr)
        total_time_avg = sum(total_time_arr)/len(total_time_arr)
        move_avg = sum(move_arr)/len(move_arr)
        correctness = len(correct_time_arr)/len(total_time_arr)
        out[fname] = {
            'correct_time_avg': correct_time_avg,
            'total_time_avg': total_time_avg,
            'move_avg': move_avg,
            'correctness': correctness,
        }
    if run == 'Brothers':
        out[run+'-Core-8'] = out[run+'-1-7']
    else:
        out[run+'-Core-8'] = out[run+'-2-7']

for run in ['Par+Base', 'Par+AB', 'Brothers']:
    for core in range(2,8):
        fname = run+'-Core-'+str(core)
        f = open('threadstats-'+fname)

        percents_out = []
        while True:
            sparks = f.readline()
            if not sparks:
                break
            total = int(sparks.split(" ")[3])
            converts = int(sparks.split(" ")[4][1:])
            percents_out.append(converts/total)

            percents_avg = sum(percents_out)/len(percents_out)
            out[fname]['percent_avg'] = percents_avg
###### End of Data Reading #######

# pprint.pprint(out)

###### Graphing Section ########
# plt.figure()
# for run in ['Par+Base', 'Par+AB', 'Brothers']:
#     md = 7
#     x = range(0,md)
#     times = []
#     for pd in x:
#         times.append(out[run+'-'+str(pd)+'-'+str(md)]['total_time_avg'])
    
#     sns.lineplot(x, times, label=run)
# plt.title("Par Depth vs. Time @ Cores=8 and Max Depth = 7")
# plt.xlabel('Par Depth')
# plt.ylabel('Time')


# plt.figure()
# for run in ['Par+Base', 'Par+AB', 'Brothers']:
#     md = 7
#     x = range(0, md)
#     sparks = []
#     for pd in x:
#         sparks.append(out[run+'-'+str(pd)+'-'+str(md)]['percent_avg'])
    
#     sns.lineplot(x, sparks, label=run)
# plt.title("Par Depth vs. Spark Conversion Rate @ Cores=8 and Max Depth = 7")
# plt.xlabel('Par Depth')
# plt.ylabel('Spark Conversion Rate')


# plt.figure()
# for run in ['Par+Base', 'Par+AB', 'Brothers']:
#     pd = 2
#     if run == 'Brothers':
#         pd = 1
#     x = range(3, 8)
#     sparks = []
#     for md in x:
#         sparks.append(out[run+'-'+str(pd)+'-'+str(md)]["percent_avg"])
    
#     sns.lineplot(x, sparks, label=run)
# plt.title("Max Depth vs. Spark Conversion Rate")
# plt.xlabel('Max Depth')
# plt.ylabel('Spark Conversion Rate')


# plt.figure()
# for run in ['Par+Base', 'Par+AB', 'Brothers']:
#     cores = range(2,9)
#     times = []
#     for core in cores:
#         times.append(out[run+'-Core-'+str(core)]['total_time_avg'])
#     sns.lineplot(cores, times, label=run)
# plt.title('# of Cores vs. Time @ Par Depth = Optimal and Max Depth = 7')
# plt.xlabel('# Cores')
# plt.ylabel('Time')


# plt.figure()
# for run in ['Par+Base', 'Par+AB', 'Brothers']:
#     cores = range(2,9)
#     times = []
#     for core in cores:
#         times.append(out[run+'-Core-'+str(core)]['percent_avg'])
#     sns.lineplot(cores, times, label=run)
# plt.title('# of Cores vs. Spark Conversion Rate @ Par Depth = Optimal and Max Depth = 7')
# plt.xlabel('# Cores')
# plt.ylabel('Spark Conversion Rate')


# plt.figure()
# times = {}
# times['x'] = ['Base', 'AB', 'Par+Base', 'Par+AB', 'Brothers']
# times['y'] = []

# for run in times['x']:
#     if run == 'Base' or run == 'AB':
#         times['y'].append(out[run+'--7']['total_time_avg'])
#     else:
#         times['y'].append(out[run+'-Core-5']['total_time_avg'])
    
# sns.barplot(x='x', y='y', data=times)
# plt.title("Timings for All Algorithms at Max Depth 7 w/ Optimized Params")
# plt.xlabel('Algorithm')
# plt.ylabel('Time')
# plt.show()

pprint.pprint(out)

plt.figure()
out2 = []
for md in range(3,8):
    out2.append(out['Brothers-1-'+str(md)]['correctness'])
sns.lineplot(range(3,8), out2)
plt.title("Max Depth vs. Game Completion Rate")
plt.xlabel('Max Depth')
plt.ylabel('Game Completion Rate')
plt.show()

# pprint.pprint(times)
