module KyoudAi where

import Board
import AlphaBetaAi
import Heuristics
import Control.Parallel.Strategies

brotherMove :: (Int,Int) -> Board -> Board
brotherMove (parD,maxD) bd = snd $ maximize (0, parD, maxD) defaultAB bd

maximize :: (Int, Int, Int) -> (Double, Double) -> Board -> (Double, Board)
maximize (d, parD, maxD) (a,b) board
    | d >= maxD = (calcScore board, board)
    | otherwise = if length bds == 0 then (calcScore board, board) else
                  getScores
    where
        bds = getAvailableMoves board
        s = chanceTime (d+1,parD,maxD) (a,b) $ head bds
        getScores
            | s >= b = (s, head bds)
            | s > a = accum (s,b) 
            | otherwise = accum (a,b)
        accum ab =
            let scoreB = (s, head bds) : (parMap rseq (\bd -> (ct' ab bd, bd)) $ tail bds) in
            foldr (\x acc -> if ((fst x) > (fst acc)) then x else acc) ((-1),[]) scoreB
        ct' = if (d > parD) then abChanceTime (d+1,maxD) else chanceTime (d+1,parD,maxD)

chanceTime :: (Int, Int, Int) -> (Double, Double) -> Board -> Double
chanceTime (d, parD, maxD) ab board 
    | d >= maxD = calcScore board
    | otherwise = let f = (min' ab board) in
                  sum $ zipWith (*) [0.9, 0.1] $ parMap rseq f [2,4]
    where min' = if d > parD then abMinimize (d+1,maxD) else minimize (d+1,parD,maxD) 

minimize :: (Int,Int,Int) -> (Double, Double) -> Board -> Tile -> Double
minimize (d, parD, maxD) (a,b) board tile
    | d >= maxD = calcScore board
    | otherwise = if length bds == 0 then calcScore board else
                  getScores
    where
        bds = map (cpuMoveDet board tile) $ getAvailableTileIndices board
        s = fst $ maximize (d+1,parD,maxD) (a,b) $ head bds
        getScores
            | s <= a = s
            | s < b = accum (a,s) 
            | otherwise = accum (a,b)
        accum ab =
            let scoreB = s : (parMap rseq (\bd -> fst $ max' ab bd) $ tail bds) in
            minimum scoreB
        max' = if d > parD then abMaximize (d+1,maxD) else maximize (d+1,parD,maxD)
