module Heuristics where

import Board
import Data.List (transpose, foldl')

-- these numbers came to me in a dream
calcScore :: Board -> Double
calcScore b = (1   * (smoothness b) +
              0.15 * (monotonicity b) +
              1.2  * (fromIntegral $ length $ getAvailableTileIndices b) +
              0.25 * (logBase 2 $ weight b) +
              9999 * (greatSuccess b))

smoothC :: [Tile] -> Int -> Int
smoothC (f:s:tl) acc | f == s    = smoothC (s:tl) (acc+1)
smoothC (_:s:tl) acc | otherwise = smoothC (s:tl) acc
smoothC _ acc = acc

smoothness :: Board -> Double
smoothness b = fromIntegral $
               (foldr smoothC 0 $ rowMap b) +
               (foldr smoothC 0 $ (transpose.rowMap) b)

gintonic :: (Int,Int) -> [Tile] -> (Int,Int)
gintonic (tot,bon) (f:s:tl) | f >= s = gintonic (tot+bon,bon+1) (s:tl)
gintonic acc (f:s:_) | f < s = acc
gintonic acc _ = acc

monotonicity :: Board -> Double
monotonicity b = fromIntegral $
                 (fst $ foldl' gintonic  (0,0) $ rowMap b) +
                 (fst $ foldl' gintonic  (0,0) $ (transpose.rowMap) b)

weight :: Board -> Double
weight b = fromIntegral $
           foldr (+) 0 $ zipWith (*) b $ map weightMap $ wHeatmap (0::Int)
           where wHeatmap n 
                    | n == 4 = []
                    | otherwise = (map (n+) [0,1,2,3]) ++ (wHeatmap (n+1))
                 weightMap n
                    | n == 0 = 1000000
                    | n == 1 = 1000
                    | n == 2 = 100
                    | n == 3 = 10
                    | otherwise = 1

greatSuccess :: Board -> Double
greatSuccess b
    | maximum b == 2048 = 99999999
    | otherwise         = 0
