module Board where

import System.Random
import Data.List (transpose)

type Tile = Int
type Board = [Tile]
type TwoDBoard = [[Tile]]

getAvailableTileIndices :: Board -> [Int]
getAvailableTileIndices board =
    snd $ unzip $ filter (\x->fst x == 0) $ zip board $ take 16 $ iterate (+1) 0 

-- places a 2 or 4 tile in a random availabe location
cpuMoveRng :: RandomGen rng => Board -> rng -> Board
cpuMoveRng board gen =
    [if t2 == idx then val else t1 | (t1,t2) <- zip board $ take 16 $ iterate (+1) 0]
    where 
        idx = (getAvailableTileIndices board) !! ridx
        ridx = fst $ randomR (0,(length $ getAvailableTileIndices board)-1) gen
        val = if (fst $ randomR (0, 9 :: Int) gen)==0 then 4 else 2

cpuMoveDet :: Board -> Int -> Int -> Board
cpuMoveDet board val idx=
    [if t2 == idx then val else t1 | (t1,t2) <- zip board $ take 16 $ iterate (+1) 0]


-- rowMap implemenation stolen from splitEvery
rowMap :: Board -> TwoDBoard
rowMap [] = []
rowMap b = let (row,rst) = splitAt 4 b in row : rowMap rst

mergeTiles :: [Tile] -> [Tile]
mergeTiles [] = []
mergeTiles (hd:nx:tl) | hd == nx = mergeTiles ((2*hd):tl)
mergeTiles (hd:tl) | otherwise = hd : mergeTiles tl

move :: Board -> Int -> Board
move b dir 
    | dir == 0 = columnUnmap $ map (mergeMaster) $ columnMap b
    | dir == 1 = columnUnmap $ map (reverse.mergeMaster.reverse) $ columnMap b
    | dir == 2 = rowUnmap $ map (mergeMaster) $ rowMap b
    | otherwise = rowUnmap $ map (reverse.mergeMaster.reverse) $ rowMap b
    where zFilt = filter (/=0)
          pad l = l ++ replicate (4 - (length (filter (/=0) l))) 0
          mergeMaster = pad.mergeTiles.zFilt
          rowUnmap = concat
          columnMap = transpose.rowMap
          columnUnmap = rowUnmap.transpose

-- up down left right
getAvailableMoves :: Board -> [Board]
getAvailableMoves b = filter (/=b) $ map (move b) [0,1,2,3]

printBoard :: Board -> IO ()
printBoard b = do
    let rb = rowMap b
    putStrLn "///////////////////"
    putStrLn $ show (rb!!0)
    putStrLn $ show (rb!!1)
    putStrLn $ show (rb!!2)
    putStrLn $ show (rb!!3)
    putStrLn "///////////////////"
