module BaseAi where

import Board
import Heuristics
import AlphaBetaAi
import Control.Parallel.Strategies

basePlayerMove :: Bool -> (Int,Int) -> Board -> Board
basePlayerMove isAB (parD,maxD) bd = snd $ maximize isAB (0, parD, maxD) bd

maximize :: Bool -> (Int, Int, Int) -> Board -> (Double, Board)
maximize isAB (d, parD, maxD) board
    | d >= maxD = (calcScore board, board)
    | otherwise = 
        let moves = getAvailableMoves board in
        let scoreB = map' (\bd -> (ct' bd, bd)) moves in
        if length moves == 0 then (calcScore board, board) else
        foldr (\x acc -> if ((fst x) > (fst acc)) then x else acc) ((-1),[]) scoreB
    where map' = if d > parD then map else parMap rpar
          ct'  = if (d >= parD) && isAB then abChanceTime (d+1,maxD) defaultAB else chanceTime isAB (d+1,parD,maxD)

chanceTime :: Bool -> (Int, Int, Int) -> Board -> Double
chanceTime isAB (d, parD, maxD) board 
    | d >= maxD = calcScore board
    | otherwise = 
        let f = (min' board) in
        sum $ zipWith (*) [0.9, 0.1] $ map' f [2,4]
    where map' = if d > parD then map else parMap rpar
          min' = if (d >= parD) && isAB then abMinimize (d+1,maxD) defaultAB else minimize isAB (d+1,parD,maxD)

minimize :: Bool -> (Int, Int, Int) -> Board -> Tile -> Double
minimize isAB (d, parD, maxD) board tile
    | d >= maxD = calcScore board
    | otherwise = 
        let nxt = map (cpuMoveDet board tile) $ getAvailableTileIndices board in
        let scoreB = map' (\bd -> fst $ max' bd) nxt in
        if length nxt == 0 then calcScore board else minimum scoreB
    where map' = if d > parD then map else parMap rpar
          max' = if (d >= parD) && isAB  then abMaximize (d+1,maxD) defaultAB else maximize isAB (d+1,parD,maxD)
