module AlphaBetaAi where

import Board
import Heuristics

minInt :: Double
minInt = 0
maxInt :: Double
maxInt = 1073741824
defaultAB :: (Double, Double)
defaultAB = (minInt, maxInt)

abPlayerMove :: Int -> Board -> Board
abPlayerMove maxD b = snd $ abMaximize (0,maxD) defaultAB b

alphaBetaMax :: (Int,Int) -> Board -> ([Double], Board) -> ([Double], Board)
alphaBetaMax (d,maxD) board ([a, b, prevOut], prevBoard)
    | localMax > a  = ([localMax, b, localMax], localBoard)
    | otherwise     = ([a, b, localMax], localBoard)
    where score = if prevOut < b
                  then abChanceTime (d+1,maxD) (a,b) board
                  else minInt
          localMax = if score >= prevOut then score else prevOut
          localBoard = if score >= prevOut then board else prevBoard
alphaBetaMax _ _ _ = ([],[])

abMaximize :: (Int,Int) -> (Double, Double) -> Board -> (Double, Board)
abMaximize (d,maxD) (a,b) board
    | d >= maxD = (calcScore board, board)
    | otherwise = 
        let f = foldr (alphaBetaMax (d,maxD)) ([a, b, minInt], []) in
        let ([_, _, lMax], localBoard) = f $ getAvailableMoves board in
        if lMax == minInt then (calcScore board, board) else (lMax, localBoard)

abChanceTime :: (Int,Int) -> (Double, Double) -> Board -> Double
abChanceTime (d,maxD) ab board
    | d >= maxD = calcScore board
    | otherwise = let f = (abMinimize (d+1,maxD) ab board) in
                  sum $ zipWith (*) [0.9, 0.1] $ map f [2,4]

alphaBetaMin :: (Int,Int) -> Board -> [Double] -> [Double]
alphaBetaMin (d,maxD) board [a, b, prevOut]
    | localMin < b  = [a, localMin, localMin]
    | otherwise     = [a, b, localMin]
    where score = if prevOut > a 
                  then fst $ abMaximize (d+1,maxD) (a,b) board
                  else maxInt
          localMin = if score <= prevOut then score else prevOut
alphaBetaMin _ _ _ = []

abMinimize :: (Int,Int) -> (Double, Double) -> Board -> Tile -> Double
abMinimize (d,maxD) (a,b) board tile
    | d >= maxD = calcScore board
    | otherwise =
        let nxt = map (cpuMoveDet board tile) $ getAvailableTileIndices board in
        if length nxt == 0 then calcScore board else
        (foldr (alphaBetaMin (d,maxD)) [a, b, maxInt] nxt) !! 2
