module Main where

import Board
import AlphaBetaAi
import BaseAi
import KyoudAi
import System.Environment(getArgs, getProgName)
import System.Exit(die)
import Control.Monad
import System.Random

play :: RandomGen rng => Int -> rng -> (Board->Board) -> Board -> IO ()
play n gen p b
    | (length $ getAvailableMoves b) == 0 = putStrLn "0"
    | maximum b == 2048 = putStrLn $ show n
    | otherwise = do
        -- printBoard b
        play (n+1) gen p $ p $ cpuMoveRng b gen

main :: IO ()
main = do 
    args <- getArgs
    case args of
        [aiType, parD, maxD] -> do
            let initBoard = replicate 16 0
            let p = chooseAi aiType (read parD) $ read maxD
            gen <- newStdGen
            play 0 gen p $ cpuMoveRng (cpuMoveRng initBoard gen) gen
        _ -> do pn <- getProgName
                die $ "Usage: " ++ pn ++ " <type> <parDepth> <maxDepth>"
        where chooseAi t parD maxD
                | t == "Base"     = basePlayerMove False (0, maxD)
                | t == "AB"       = abPlayerMove maxD
                | t == "Par+Base" = basePlayerMove False (parD, maxD)
                | t == "Par+AB"   = basePlayerMove True (parD, maxD)
                | t == "Brothers" = brotherMove (parD, maxD)
                | otherwise = chooseAi "Base" parD maxD
