module Main where

import Lib
--parallel

import System.Environment(getArgs, getProgName)
import System.IO()
import System.Exit(die)
import Data.Char(toLower)
import Data.List
import Data.Maybe
import Control.Parallel.Strategies(using, parListChunk, rseq)

main :: IO ()
main = do
 args <- getArgs
 case args of
  [filename] -> do
   contents <- readFile filename
   let lwords = cleaningWords contents
   let solutions = (buildFinalList lwords) `using` parListChunk 5000 rseq 
   print (solutions)

  _ -> do
   pn <- getProgName
   die $ "Usage: " ++ pn ++ " <filename>"

cleaningWords :: String -> [String]
cleaningWords s = words (map toLower s)

buildFinalList :: [String] -> [String]
buildFinalList [] = []
buildFinalList (x:xs) = [getFinalColumn (sortOn (map toLower) (createAllRotations (length x) x))] ++ (buildFinalList xs)

createAllRotations :: Int -> String -> [String]
createAllRotations 0 _ = []
createAllRotations n word = [w] ++ (createAllRotations (n-1) w)
 where w = rotateWord word

getFinalColumn :: [String] -> String
getFinalColumn [] = []
getFinalColumn (x:xs) = [last x] ++ (getFinalColumn xs)

rotateWord :: [Char] -> [Char] --rotate "hello" --> "ohell"
rotateWord word = take len $ drop (negate 1 `mod` len) $ cycle word
 where len = length word

