module Lib
    (readCNF
    ) where

import Data.Array.Unboxed
import Language.CNF.Parse.ParseDIMACS as DIMACS

readCNF :: FilePath -> IO (Either [Char] [[Integer]])
readCNF filename = do
    cnfFile <- DIMACS.parseFile filename
    case cnfFile of 
        Left _ -> return $ Left "Error loading CNF file"
        Right cnfUarray -> return $ Right $ createFormula cnfUarray 


createFormula :: CNF -> [[Integer]]
createFormula cnfUarray = map (map (toInteger) . elems) $ clauses cnfUarray