module Main where

import Lib
import BoolSat
import Control.Monad
import System.Environment(getArgs)



{-- Run stack build to build the code.
	Main is set up for 3 types of tests:

--}

-- >>> 1: tests a parallel dpll that has no max 
--        parallelization depth

-- main = do 
-- 	args <- getArgs
-- 	case args of
-- 		[filename] -> do
-- 			cnfFormula <- readCNF filename
-- 			case cnfFormula of 
-- 				Left e -> putStrLn e 
-- 				Right formula -> putStrLn $ 
-- 				                 show $ 
-- 				                 parDpllSolve formula
-- 		_ -> putStrLn "Usage: stack run <cnf file path>"


-- >>> 2: tests a parallel dpll that has a max 
--        parallelization depth

main = do 
	args <- getArgs
	case args of
		[filename, depth] -> do
			cnfFormula <- readCNF filename
			let d = read $ depth
			case cnfFormula of 
				Left e -> putStrLn e 
				Right formula -> putStrLn $ 
				                 show $ 
				                 parDpllSolve3 d formula
		_ -> putStrLn "Usage: stack run <cnf file path> <depth of parallelism>"


-- >>> 3: tests a sequential dpll

-- main = do 
-- 	args <- getArgs
-- 	case args of
-- 		[filename] -> do
-- 			cnfFormula <- readCNF filename
-- 			case cnfFormula of 
-- 				Left e -> putStrLn e 
-- 				Right formula -> putStrLn $ 
-- 				                 show $ 
-- 				                 seqDpllSolve formula
-- 		_ -> putStrLn "Usage: ./sequential <cnf file path>"
