module Main where

import BuildKnowledgeBase (buildKnowledgeBase)
import AutoComplete (autoComplete)
import System.Environment (getArgs, getProgName)

main :: IO ()
main = do
  args <- getArgs
  case args of
    ["--build-knowledge-base", inputFile, outputDir] ->
        buildKnowledgeBase inputFile outputDir
    ["--auto-complete", knowledgeBaseDir, inputFile] ->
        autoComplete knowledgeBaseDir inputFile
    _ -> putStrLn "Bad args"
