(*Authors: 
Ajita Bala ab4420
Karen Shi ks3650*) 

(* Ocamllex Scanner for nodable *) 

{ open Nodableparser } 

let digit = ['0' - '9'] 
let letter = ['a' - 'z' 'A' - 'Z'] 
let integers = digit+
let dec = (integers '.' digit*)
let name = letter ['a' - 'z' 'A' - 'Z' '0'-'9' '_']*

rule token = 
parse
[' ' '\n' '\r' '\t'] {token lexbuf} 
| '+' { PLUS } 
| '-' { MINUS } 
| '*' { TIMES }
| '/' { DIVIDE } 
| '%' { MODULO }
| '=' { ASSIGN }
| ',' { COMMA }
| ';' { SEMI }
| '(' { LPAREN }
| ')' { RPAREN }
| '{' { LBRACE }
| '}' { RBRACE }
| '[' { LSQUARE }
| ']' { RSQUARE }
| '.' { DOT }
| '$' { DOLLAR }


| "==" { EQ }
| "!=" { NEQ }
| '!' { NOT }
| '<' { LT }
| '>' { GT }
| ">=" { GEQ }
| "<=" { LEQ }
| "true" { BOOL_LIT(true) }
| "false" { BOOL_LIT(false) }

| "if" { IF } 
| "else" { ELSE }
| "&&" { AND }
| "||" { OR } 
| "for" { FOR }
| "while" { WHILE }
| "return" { RETURN } 


| "void" { VOID }
| "int" { INT }
| "float" { FLOAT }
| "boolean" { BOOL }
| "string" { STRING }
| "node" { NODE }
| "list" { LIST }
| "true"   { BOOL_LIT(true)  }
| "false"  { BOOL_LIT(false) }

| name as lxm { ID(lxm) } 
| integers as lxm { INT_LIT(int_of_string lxm) } 
| digit+ '.'  digit* as lxm { FLT_LIT(lxm) }
| '\"' ([^'\"']* as lxm) '\"' {STR_LIT(lxm)} 

| eof { EOF }
| _ as char { raise (Failure("illegal character " ^ Char.escaped char)) }

| "//" {comment lexbuf} 

and comment = parse 
"//" {token lexbuf} 
| _ {comment lexbuf} (* Ignore other characters *) 
