#ifndef _LIST_H_
#define _LIST_H_

#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>

/* Members of the List */
struct ListObj {
    void *data;
    struct ListObj *next;
};

/* The list itself */
struct List {
    struct ListObj *head;
};

/* The Node struct */ 
struct Node { 
	void *data;
    struct Node* left;
    struct Node* right;

};

/* Function to Initialize list */
struct List *list_init();

/* Function to add elements */
void add_elem(struct List *list, void *data);

/* Adds to the back of the list */
void append (struct List *list, void *data);

/* Function to index and retrieve list elements */
struct ListObj *get_elem(int n, struct List *list);

/* Function to update list element at given index with given value */
struct List *update_elem(void* data, struct List *list, int index); 

static inline int isEmptyList(struct List *list)
{
    return (list->head == NULL);
}

int size(struct List *list);

/* NODE FUNCTIONS START HERE */

struct Node *init_node (void *input);

void *get_data(struct Node *node);

struct Node *get_right (struct Node *node);

struct Node *get_left (struct Node *node);


void add_left (struct Node* node, struct Node* node2);

void add_right (struct Node* node, struct Node* node2);

/*
int size(struct List *list);

void *list_get(int n, struct List *list);

void push_front_list(struct List *list, void *data);

void pop_front_list(struct List *list);

void pop_list(struct List *list);

int isEmptyList(struct List *list);

void reverseList(struct List *list);

struct List *copy(struct List *list);

void removeAllNodes(struct List *list);

bool isEqual(struct ListNode *a, struct ListNode *b);

struct List *list_remove(struct List *list, void *y);

struct List *insert(int x, struct List *list, void *y);

struct ListNode *addAfter(struct List *list, struct ListNode *prevNode, void *data);
*/

#endif /* #ifndef _MYLIST_H_ */
