#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>

#include "c_library.h"

struct List *list_init() {
	struct List *list = (struct List *)malloc(sizeof(struct List));
	list->head = NULL;
	return list;
}

/*adds elements to the front of the list? */
void add_elem(struct List *list, void *data) {
    struct ListObj *node = (struct ListObj *)malloc(sizeof(struct ListObj));
    if (node == NULL)
		return;
    node->data = data;
    node->next = list->head;
    list->head = node;
}

void append (struct List *list, void *data) {
	    // make the new node that will go to the end of list
    struct ListObj *node = (struct ListObj *)malloc(sizeof(struct ListObj));
    node->data = data;
    node->next = NULL;

    // if the list is empty, this node is the head
    if (list->head == NULL) {
	list->head = node;
    }

    // find the last node
    struct ListObj *end = list->head;
    while (end->next != NULL)
	end = end->next;

    // 'end' is the last node at this point
    end->next = node;
}

/* Gets an element by an inputted index */
struct ListObj *get_elem(int n, struct List *list) {
    if( n >= size(list) ) {
        fprintf(stderr, "Index out of bounds.");
		exit(-1);
    }

	struct ListObj *cur = list->head;
	int count = 0;

	while (cur != NULL) {
		if (count == n)
			return (cur->data);
		
		count++;
		cur = cur->next;
	}
}

/* Updates an element at an inputted index with an inputted value */
struct List *update_elem(void* data, struct List *list, int index) {	
	if(isEmptyList(list)) {
		return list;
	}

	struct ListObj *node = list->head;
	
	///if index is wrong, return original list 
	if( index >= size(list) ) {
                fprintf(stderr, "List Index out of bounds: given %d for list of size %d\n", index, size(list));
                exit(-1);
        }

	if(index == 0){
		node->data = data;
		return list;
	}

	for( int i = 0 ; i!=index ; i++ ) node = node->next;
	
	node->data = data;   	

	return list; 			 
}

/* Returns the size of the list */
int size(struct List *list) {
	
	if (isEmptyList(list)) {
		return 0;
	}	
	int count = 0;
	struct ListObj *cur = list->head;
	
	while(cur != NULL) {
		count++;
		cur = cur->next; 
	} 
	return count;	
}

/* Initializes a node */
struct Node *init_node (void *input) {
	struct Node *node = (struct Node *)malloc(sizeof(struct Node));
	node->data = input;
	node->left = NULL;
	node->right = NULL;
	return node;
}

void *get_data(struct Node *node) {
    return node->data;
}

struct Node *get_left (struct Node *node) {
	return node->left;
}

struct Node *get_right (struct Node *node) {
	return node->right;
}



void add_left (struct Node* node, struct Node* node2) {
	node->left = node2;
}

void add_right (struct Node* node, struct Node* node2) {
	node->right = node2;
}