#define OPENCV_TRAITS_ENABLE_DEPRECATED

#include "opencv2/imgproc/imgproc.hpp"
#include "opencv2/imgcodecs.hpp"
#include "opencv2/highgui/highgui.hpp"
#include <iostream>
#include <string>
#include <math.h>
#include <stdlib.h>
#include <stdio.h>

using namespace cv;

static void die(const char *message)
{
    perror(message);
    exit(1);
}

struct matrix {
    int rows;
    int cols;
    float** matrixAddr;
};
struct image {
    matrix* red;
    matrix* green;
    matrix* blue;
    matrix* grayscale;
};
float** getMat (Mat mat) {
    float** matrixValues = (float**) malloc(mat.rows * sizeof(float*));
    for (int i = 0; i < mat.rows; i++) {
        float* matrix_row = (float*) malloc(mat.cols * sizeof(float));
        *(matrixValues + i) = matrix_row;
        for (int j = 0; j < mat.cols; j++) {
            matrix_row[j] = mat.at<float>(i, j);
        }
    }
    return matrixValues;
}
float* get1D (float** matrix2d, int n, int m) {
    float* b;
    for (int i = 0; i < n; i++) {
        for (int j = 0; j < m; j++) {
            b[i * m + j] = matrix2d[i][j];
        }
    }
    return b;
}
matrix* initMatrix(float* data, int num_rows, int num_cols) {
    Mat newMatrix = Mat::zeros(num_rows, num_cols, CV_32F);
    for (int i = 0; i < (num_rows * num_cols); i++) {
        newMatrix.at<float>(i) = data[i];
    }

    matrix* result = (matrix*) malloc(sizeof(struct matrix));
    result->cols = num_cols;
    result->rows = num_rows;
    result->matrixAddr = getMat(newMatrix);

    return result;
}
float access(matrix* src, int row, int col) {
    return src->matrixAddr[row][col];
}
void accessAssign(matrix* src, int row, int col, float value) {
    src->matrixAddr[row][col] = value;
}
// image_in         : String filePath, String mode            -> image
image* image_in (String filePath, String mode) {
    Mat rgb, g;
    if (mode == "COLOR") {
        imread(filePath, IMREAD_COLOR).convertTo(rgb, CV_32F, 1, 0);
        imread(filePath, IMREAD_GRAYSCALE).convertTo(g, CV_32F, 1, 0);

        if (!rgb.data || !g.data) {
            die("Error processing image");
        }
        std::cout << "Finished loading\n" << std::endl;

        std::vector<Mat> p;
        split(rgb, p);

        Mat nr = Mat::zeros(p[2].rows, p[2].cols, CV_32F);
        for (int i = 0; i < p[2].rows; i++) {
            for (int j = 0; j < p[2].cols; j++) {
                nr.at<float>(i, j) = p[2].at<float>(i, j);
            }
        }
        Mat ng = Mat::zeros(p[1].rows, p[1].cols, CV_32F);
        for (int i = 0; i < p[1].rows; i++) {
            for (int j = 0; j < p[1].cols; j++) {
                ng.at<float>(i, j) = p[1].at<float>(i, j);
            }
        }
        Mat nb = Mat::zeros(p[0].rows, p[0].cols, CV_32F);
        for (int i = 0; i < p[0].rows; i++) {
            for (int j = 0; j < p[0].cols; j++) {
                nb.at<float>(i, j) = p[0].at<float>(i, j);
            }
        }
        Mat ngs = Mat::zeros(g.rows, g.cols, CV_32F);
        for (int i = 0; i < g.rows; i++) {
            for (int j = 0; j < g.cols; j++) {
                ngs.at<float>(i, j) = g.at<float>(i, j);
            }
        }

        image* result = (image*) malloc(sizeof(struct image));
        std::cout << "Loaded memory for image struct\n" << std::endl;
        result->red = initMatrix(get1D(getMat(nr), nr.rows, nr.cols), nr.rows, nr.cols);
        std::cout << "Saved red\n" << std::endl;
        result->green = initMatrix(get1D(getMat(ng), ng.rows, ng.cols), ng.rows, ng.cols);
        std::cout << "Saved green\n" << std::endl;
        result->blue = initMatrix(get1D(getMat(nb), nb.rows, nb.cols), nb.rows, nb.cols);
        std::cout << "Saved blue\n" << std::endl;
        result->grayscale = initMatrix(get1D(getMat(ngs), ngs.rows, ngs.cols), ngs.rows, ngs.cols);
        std::cout << "Saved grayscale\n" << std::endl;
        return result;
    } else if (mode == "GRAYSCALE") {
        imread(filePath, IMREAD_GRAYSCALE).convertTo(g, CV_32F, 1, 0);

        if (!g.data) {
            die("Error processing image");
        }
        std::cout << "Finished loading\n" << std::endl;
        image* result = (image*) malloc(sizeof(struct image));
        std::cout << "Loaded memory for image struct\n" << std::endl;
        result->grayscale = initMatrix(get1D(getMat(g), g.rows, g.cols), g.rows, g.cols);
        std::cout << "Saved grayscale\n" << std::endl;

        return result;
    } else {
        die("invalid color mode: <COLOR, GRAYSCALE>");
    }
}
// image_out        : String filePath, image img, String mode -> void
void image_out (String filePath, image* img, String mode) {
    if (mode == "COLOR") {
        Mat dst  = Mat::zeros(img->red->rows, img->red->cols, CV_32F);
        Mat final = Mat::zeros(img->red->rows, img->red->cols, CV_32F);

        std::vector<Mat> channels;
        Mat nr = Mat::zeros(img->red->rows, img->red->cols, CV_32F);
        for (int i = 0; i < img->red->rows; i++) {
            for (int j = 0; j < img->red->cols; j++) {
                nr.at<float>(i, j) = img->red->matrixAddr[i][j];
            }
        }
        Mat ng = Mat::zeros(img->green->rows, img->green->cols, CV_32F);
        for (int i = 0; i < img->green->rows; i++) {
            for (int j = 0; j < img->green->cols; j++) {
                ng.at<float>(i, j) = img->green->matrixAddr[i][j];
            }
        }
        Mat nb = Mat::zeros(img->blue->rows, img->blue->cols, CV_32F);
        for (int i = 0; i < img->blue->rows; i++) {
            for (int j = 0; j < img->blue->cols; j++) {
                nb.at<float>(i, j) = img->blue->matrixAddr[i][j];
            }
        }

        channels.push_back(nb);
        channels.push_back(ng);
        channels.push_back(nr);

        std::cout << "start merge" << std::endl;
        merge(channels, dst);

        imwrite(filePath, dst);
    } else if (mode == "GRAYSCALE") {
        Mat dst  = Mat::zeros(img->grayscale->rows, img->grayscale->cols, CV_32F);
        Mat final = Mat::zeros(img->grayscale->rows, img->grayscale->cols, CV_32F);
        Mat GS = Mat::zeros(img->grayscale->rows, img->grayscale->cols, CV_32F);
        for (int i = 0; i < img->grayscale->rows; i++) {
            for (int j = 0; j < img->grayscale->cols; j++) {
                GS.at<float>(i, j) = img->grayscale->matrixAddr[i][j];
            }
        }
        std::cout << GS << std::endl;
        imwrite(filePath, GS);
    } else {}
}
// join (color)     : matrix red, matrix blue, matrix green  -> image
image* join (matrix* red, matrix* green, matrix* blue) {
    Mat R = Mat::zeros(red->rows, red->cols, CV_32F);
    for (int i = 0; i < red->rows; i++) {
        for (int j = 0; j < red->cols; j++) {
            R.at<float>(i, j) = red->matrixAddr[i][j];
        }
    }
    Mat G = Mat::zeros(green->rows, green->cols, CV_32F);
    for (int i = 0; i < green->rows; i++) {
        for (int j = 0; j < green->cols; j++) {
            G.at<float>(i, j) = green->matrixAddr[i][j];
        }
    }
    Mat B = Mat::zeros(blue->rows, blue->cols, CV_32F);
    for (int i = 0; i < blue->rows; i++) {
        for (int j = 0; j < blue->cols; j++) {
            B.at<float>(i, j) = blue->matrixAddr[i][j];
        }
    }

    image* result = (image*) malloc(sizeof(struct image));
    result->red = initMatrix(get1D(getMat(R), R.rows, R.cols), R.rows, R.cols);
    result->green = initMatrix(get1D(getMat(G), G.rows, G.cols), G.rows, G.cols);
    result->blue = initMatrix(get1D(getMat(B), B.rows, B.cols), B.rows, B.cols);
    std::cout << "finished creating joined color image" << std::endl;
    return result;
}
// join (grayscale) : matrix grayscale                       -> image
image* join (matrix* grayscale) {
    Mat GS = Mat::zeros(grayscale->rows, grayscale->cols, CV_32F);
    for (int i = 0; i < grayscale->rows; i++) {
        for (int j = 0; j < grayscale->cols; j++) {
            GS.at<float>(i, j) = grayscale->matrixAddr[i][j];
        }
    }

    image* result = (image*) malloc(sizeof(struct image));
    result->grayscale = initMatrix(get1D(getMat(GS), GS.rows, GS.cols), GS.rows, GS.cols);
    return result;
}
// multiply_matrix  : matrix A, matrix B                     -> matrix
matrix* multiply_matrix (matrix* lhs, matrix* rhs) {
    Mat A = Mat::zeros(lhs->rows, lhs->cols, CV_32F);
    for (int i = 0; i < lhs->rows; i++) {
        for (int j = 0; j < lhs->cols; j++) {
            A.at<float>(i, j) = lhs->matrixAddr[i][j];
        }
    }
    Mat B = Mat::zeros(rhs->rows, rhs->cols, CV_32F);
    for (int i = 0; i < rhs->rows; i++) {
        for (int j = 0; j < rhs->cols; j++) {
            B.at<float>(i, j) = rhs->matrixAddr[i][j];
        }
    }

    Mat C = A * B;

    matrix* result = (matrix*) malloc(sizeof(struct matrix));
    result->cols = rhs->cols;
    result->rows = lhs->rows;
    result->matrixAddr = getMat(C);
    return result;
}
// add_matrix       : matrix A, matrix B                     -> matrix
matrix* add_matrix (matrix* lhs, matrix* rhs) {
    Mat A = Mat::zeros(lhs->rows, lhs->cols, CV_32F);
    for (int i = 0; i < lhs->rows; i++) {
        for (int j = 0; j < lhs->cols; j++) {
            A.at<float>(i, j) = lhs->matrixAddr[i][j];
        }
    }
    Mat B = Mat::zeros(rhs->rows, rhs->cols, CV_32F);
    for (int i = 0; i < rhs->rows; i++) {
        for (int j = 0; j < rhs->cols; j++) {
            B.at<float>(i, j) = rhs->matrixAddr[i][j];
        }
    }

    Mat C = A + B;

    matrix* result = (matrix*) malloc(sizeof(struct matrix));
    result->cols = rhs->cols;
    result->rows = lhs->rows;
    result->matrixAddr = getMat(C);
    return result;
}
// scale_matrix     : matrix A, float s                       -> matrix
matrix* scale_matrix (matrix* m, float s) {
    Mat A = Mat::zeros(m->rows, m->cols, CV_32F);
    for (int i = 0; i < m->rows; i++) {
        for (int j = 0; j < m->cols; j++) {
            A.at<float>(i, j) = m->matrixAddr[i][j];
        }
    }

    Mat C = A * s;

    matrix* result = (matrix*) malloc(sizeof(struct matrix));
    result->cols = m->cols;
    result->rows = m->rows;
    result->matrixAddr = getMat(C);
    return result;
}
// exp_matrix       : matrix A, float exp                     -> matrix
matrix* exp_matrix (matrix* m, float exp) {
    Mat A = Mat::zeros(m->rows, m->cols, CV_32F);
    for (int i = 0; i < m->rows; i++) {
        for (int j = 0; j < m->cols; j++) {
            A.at<float>(i, j) = pow(m->matrixAddr[i][j], exp);
        }
    }

    matrix* result = (matrix*) malloc(sizeof(struct matrix));
    result->cols = m->cols;
    result->rows = m->rows;
    result->matrixAddr = getMat(A);
    return result;
}
// convolute        : matrix src, matrix kernel              -> matrix
// Mat_<float> convolute(const Mat_<float>& src, const Mat_<float>& kernel) {
matrix* convolute(matrix* s, matrix* k) {
    Mat src = Mat::zeros(s->rows, s->cols, CV_32F);
    for (int i = 0; i < s->rows; i++) {
        for (int j = 0; j < s->cols; j++) {
            src.at<float>(i, j) = s->matrixAddr[i][j];
        }
    }
    Mat kernel = Mat::zeros(k->rows, k->cols, CV_32F);
    for (int i = 0; i < k->rows; i++) {
        for (int j = 0; j < k->cols; j++) {
            kernel.at<float>(i, j) = k->matrixAddr[i][j];
        }
    }
    Mat dst(src.rows, src.cols, CV_32F);

    Mat flipped_kernel(kernel.rows, kernel.cols, CV_32F);
    flip(kernel, flipped_kernel, -1);

    const int dx = kernel.cols / 2;
    const int dy = kernel.rows / 2;

    for (int i = 0; i<src.rows; i++) 
    {
        for (int j = 0; j<src.cols; j++) 
        {
            float tmp = 0.0f;
            for (int k = 0; k<flipped_kernel.rows; k++) 
            {
              for (int l = 0; l<flipped_kernel.cols; l++) 
              {
                int x = j - dx + l;
                int y = i - dy + k;
                if (x >= 0 && x < src.cols && y >= 0 && y < src.rows)
                    tmp += src.at<float>(y, x) * flipped_kernel.at<float>(k, l);
              }
            }
            dst.at<float>(i, j) = saturate_cast<float>(tmp);
        }
    }
    Mat final = Mat::zeros(dst.rows, dst.cols, CV_32F);
    for (int i = 0; i < dst.rows; i++) {
        for (int j = 0; j < dst.cols; j++) {
            final.at<float>(i, j) = dst.at<float>(i, j);
        }
    }
    matrix* result = (matrix*) malloc(sizeof(struct matrix));
    result->cols = final.cols;
    result->rows = final.rows;
    result->matrixAddr = getMat(final);
    return result;
}
matrix* zeros(int rows, int cols) {
    Mat zm = Mat::zeros(rows, cols, CV_32F);
    matrix* result = (matrix*) malloc(sizeof(struct matrix));
    result->cols = cols;
    result->rows = rows;
    result->matrixAddr = getMat(zm);
    return result;
}

int main() {    
    //SOBEL HORIZONTAL
    //---
    float floatsGS[] = { 1, 1, 1, 0, 0, 0, -1, -1, -1 };
    matrix* kernel = initMatrix(floatsGS, 3, 3);
    image* a = image_in("./steam-engine.png", "GRAYSCALE");
    matrix* cvgs = convolute(a->grayscale, kernel);
    image* final = join(cvgs);
    image_out("./FROMCPP.png", final, "GRAYSCALE");

    //BLUR COLOR
    //----
    // float floatsC[] = { 1, 1, 1, 1, 1, 1, 1, 1, 1 };
    // matrix* kernel = initMatrix(floatsC, 3, 3);
    // image* a = image_in("./cat.png", "COLOR");
    // matrix* cvr = scale_matrix(convolute(a->red, kernel), 0.11);
    // matrix* cvg = scale_matrix(convolute(a->green, kernel), 0.11);
    // matrix* cvb = scale_matrix(convolute(a->blue, kernel), 0.11);
    // image* final = join(cvr, cvg, cvb);
    // image_out("./FROMCPP.png", final, "COLOR");

    //MATRIX SCALAR
    //---
    // float floatsM[] = {1, 1, 1, 1, 1, 1, 1, 1, 1};
    // matrix* base = initMatrix(floatsM, 3, 3);
    // matrix* final = scale_matrix(base, 3);
    // for (int i = 0; i < final->rows; i++) {
    //     for (int j = 0; j < final->cols; j++) {
    //         std::cout << final->matrixAddr[i][j] << " ";
    //     }
    // }
    // std::cout << std::endl;

    // MATRIX ADDITION
    // ---
    // float floatsM[] = {1, 1, 1, 1, 1, 1, 1, 1, 1};
    // matrix* A = initMatrix(floatsM, 3, 3);
    // matrix* B = initMatrix(floatsM, 3, 3);
    // matrix* final = add_matrix(A, B);
    // for (int i = 0; i < final->rows; i++) {
    //     for (int j = 0; j < final->cols; j++) {
    //         std::cout << final->matrixAddr[i][j] << " ";
    //     }
    // }
    // std::cout << std::endl;
    
    // MATRIX MULTIPLICATION
    // ---
    // float floatsA[] = {-1, 4, 2, 3};
    // float floatsB[] = {9, -3, 6, 1};
    // matrix* A = initMatrix(floatsA, 2, 2);
    // matrix* B = initMatrix(floatsB, 2, 2);
    // matrix* final = multiply_matrix(A, B);
    // for (int i = 0; i < final->rows; i++) {
    //     for (int j = 0; j < final->cols; j++) {
    //         std::cout << final->matrixAddr[i][j] << " ";
    //     }
    // }
    // std::cout << std::endl;

    // MATRIX EXPONENTS
    // ---
    // float floatsM[] = {2, 2, 2, 2};
    // matrix* base = initMatrix(floatsM, 2, 2);
    // matrix* final = exp_matrix(base, 3);
    // for (int i = 0; i < final->rows; i++) {
    //     for (int j = 0; j < final->cols; j++) {
    //         std::cout << final->matrixAddr[i][j] << " ";
    //     }
    // }
    // std::cout << std::endl;

    // MATRIX ACCESS
    // ---
    // float matA[] = {1, 1, 1, 1, 1, 1, 1, 1, 1};
    // matrix* A = initMatrix(matA, 3, 3);
    // std::cout << access(A, 0, 0) << std::endl;

    // MATRIX ACCESS ASSIGN
    // ---
    // float matA[] = {1, 1, 1, 1, 1, 1, 1, 1, 1};
    // matrix* A = initMatrix(matA, 3, 3);
    // accessAssign(A, 0, 0, 200);
    // std::cout << access(A, 0, 0) << std::endl;

    // ZERO MATRIX
    // ---
    // matrix* A = zeros(3, 3);
    // for (int i = 0; i < A->rows; i++) {
    //     for (int j = 0; j < A->cols; j++) {
    //         std::cout << A->matrixAddr[i][j] << " ";
    //     }
    // }
    // std::cout << std::endl;
}