%token SEMI LPAREN RPAREN LBRACE RBRACE COMMA DOT SPACE
%token PLUS MINUS TIMES DIVIDE ASSIGN NOT
%token EQ NEQ LT LEQ GT GEQ AND OR
%token RETURN IF ELSE FOR WHILE INT LIST DICT PIXEL VOID
%token FLOAT STRING MATRIX ROWS COLS IMAGE
%token RED GREEN BLUE TRANSPOSE BRIGHTNESS CONVERT
%token MOD FUNC DBLCOLON LBRACK RBRACK
%token <int> LITERAL
%token <float> FLOAT_LITERAL
%token <string> STR_LITERAL
%token <string> ID
%token EOF

%start program
%type <Ast.program> program

%nonassoc NOELSE
%nonassoc ELSE
%right ASSIGN
%left OR
%left AND
%left EQ NEQ
%left LT GT LEQ GEQ
%left PLUS MINUS
%left TIMES DIVIDE MOD
%right NOT NEG

%%

program:
  decls EOF { $1 }

decls:
   /* nothing */ { ([], [])               }
 | decls vdecl { (($2 :: fst $1), snd $1) }
 | decls fdecl { (fst $1, ($2 :: snd $1)) }

fdecl:
  FUNC DBLCOLON typ ID LPAREN formals_opt RPAREN LBRACE vdecl_list stmt_list RBRACE
  { () }

formals_opt:
    /* nothing */ { [] }
  | formal_list   { $1 }

formal_list:
    typ ID                   { [($1, $2)]     }
  | formal_list COMMA typ ID { ($3, $4) :: $1 }

typ:
    INT    { () }
  | FLOAT  { () }
  | STRING { () }
  | VOID   { () }
  | LIST   { () }
  | DICT   { () }
  | PIXEL  { () }
  | MATRIX { () }
  | IMAGE  { () }

vdecl_list:
    /* nothing */    { [] }
  | vdecl_list vdecl { $2 :: $1 }

vdecl:
   typ ID SEMI { ($1, $2) }

stmt_list:
    /* nothing */  { [] }
  | stmt_list stmt { $2 :: $1 }

stmt:
    expr SEMI                               { () }
  | RETURN expr_opt SEMI                    { () }
  | LBRACE stmt_list RBRACE                 { () }
  | IF LPAREN expr RPAREN stmt %prec NOELSE { () }
  | IF LPAREN expr RPAREN stmt ELSE stmt    { () }
  | FOR LPAREN expr_opt SEMI expr SEMI expr_opt RPAREN stmt
                                            { () }
  | WHILE LPAREN expr RPAREN stmt           { () }
  // | typ ID ASSIGN expr SEMI { () }

expr_opt:
    /* nothing */ { () }
  | expr          { $1 }

expr:
    LITERAL          { () }
  | FLOAT_LITERAL	   { () }
  | STR_LITERAL      { () }
  | ID               { () }
  | matrix_literal   { () }
  | expr PLUS   expr { () }
  | expr MINUS  expr { () }
  | expr TIMES  expr { () }
  | expr DOT TIMES expr { () }
  | expr DIVIDE expr { () }
  | expr DOT DIVIDE expr { () }
  | expr MOD    expr { () }
  | expr EQ     expr { () }
  | expr NEQ    expr { () }
  | expr LT     expr { () }
  | expr LEQ    expr { () }
  | expr GT     expr { () }
  | expr GEQ    expr { () }
  | expr AND    expr { () }
  | expr OR     expr { () }
  | MINUS expr %prec NEG { () }
  | NOT expr         { () }
  | ID ASSIGN expr   { () } // assign an initialized variable
  | ID LPAREN args_opt RPAREN { () } // call a function with list args_opt
  | LPAREN expr RPAREN { $2 }
  | ID DOT RED { () }
  | ID DOT BLUE { () }
  | ID DOT GREEN { () }
  | ID DOT ROWS { () }
  | ID DOT COLS { () }
  | ID DOT TRANSPOSE { () }
  | ID DOT BRIGHTNESS { () }
  | ID DOT CONVERT { () }
  | ID LBRACK expr RBRACK { () } // list access
  | ID LBRACK expr COMMA expr RBRACK { () } // matrix access
  | typ LPAREN expr RPAREN { () } // cast

args_opt:
    /* nothing */ { [] }
  | args_list  { List.rev $1 }

args_list:
    expr                    { [$1] }
  | args_list COMMA expr { $3 :: $1 }

matrix_literal:
    LBRACK RBRACK             { [[]] } // empty matrix
  | LBRACK matrix_body RBRACK { $2 }

matrix_body:
    matrix_row { [$1] }
  | matrix_body matrix_row { $2 :: $1 }

matrix_row:
    LITERAL { [$1] }
  | FLOAT_LITERAL { [$1] }
  | MINUS LITERAL { [$2] }
  | MINUS FLOAT_LITERAL { [$2] }
  // | MINUS LITERAL %prec NEG { [$2] }
  // | MINUS FLOAT_LITERAL %prec NEG { [$2] }
  | matrix_row SPACE LITERAL { $3 :: $1 }
  // | matrix_row SPACE MINUS LITERAL %prec NEG { $4 :: $1 }
  | matrix_row SPACE MINUS LITERAL { $4 :: $1 }
  | matrix_row SPACE FLOAT_LITERAL { $3 :: $1 }
  // | matrix_row SPACE MINUS FLOAT_LITERAL %prec NEG { $4 :: $1 }
  | matrix_row SPACE MINUS FLOAT_LITERAL { $4 :: $1 }