(*Scanner for Lucifer
Authors: Cherry Chu, Michael Fagan
Citation: Microc scanner.mll*)

{ open Luciferparse }

let digit = ['0' - '9']
let digits = digit+

rule token = parse
  [' ' '\t' '\r' '\n'] { token lexbuf } (* Whitespace *)
| "/*"     { comment lexbuf }           (* Comments *)
| "//"     { single_comment lexbuf }     (* Single line comments *)
| '('      { LPAREN }
| ')'      { RPAREN }
| '{'      { LBRACE }
| '}'      { RBRACE }
| ';'      { SEMI }
| ','      { COMMA }
| '+'      { PLUS }
| '-'      { MINUS }
| '*'      { TIMES }
| '/'      { DIVIDE }
| '%'      { MOD }
| '='      { ASSIGN }
| "=="     { EQ }
| "!="     { NEQ }
| '<'      { LT }
| "<="     { LEQ }
| ">"      { GT }
| ">="     { GEQ }
| "&&"     { AND }
| "||"     { OR }
| "!"      { NOT }
| "if"     { IF }
| "else"   { ELSE }
| "for"    { FOR }
| "while"  { WHILE }
| "runGame"{ RUNGAME }
| "return" { RETURN }
| "int"    { INT }
| "bool"   { BOOL }
| "float"  { FLOAT }
| "string" { STRING }
| "void"   { VOID }
| "true"   { BLIT(true)  }
| "false"  { BLIT(false) }
| "fun"    { FUN }
| "new"    { NEW }
| "Player" { PLAYER }
| "Entity" { ENTITY }
| "."      { DOT }
| "SDL_SCANCODE_SPACE"    {LITERAL(44)}
| "SDL_SCANCODE_RIGHT"    {LITERAL(79)}
| "SDL_SCANCODE_LEFT"    {LITERAL(80)}
| "SDL_SCANCODE_DOWN"    {LITERAL(81)}
| "SDL_SCANCODE_UP"    {LITERAL(82)}
| "SDL_SCANCODE_A"    {LITERAL(4)}
| "SDL_SCANCODE_B"    {LITERAL(5)}
| "SDL_SCANCODE_C"    {LITERAL(6)}
| "SDL_SCANCODE_D"    {LITERAL(7)}
| "SDL_SCANCODE_E"    {LITERAL(8)}
| "SDL_SCANCODE_F"    {LITERAL(9)}
| "SDL_SCANCODE_G"    {LITERAL(10)}
| "SDL_SCANCODE_H"    {LITERAL(11)}
| "SDL_SCANCODE_I"    {LITERAL(12)}
| "SDL_SCANCODE_J"    {LITERAL(13)}
| "SDL_SCANCODE_K"    {LITERAL(14)}
| "SDL_SCANCODE_L"    {LITERAL(15)}
| "SDL_SCANCODE_M"    {LITERAL(16)}
| "SDL_SCANCODE_N"    {LITERAL(17)}
| "SDL_SCANCODE_O"    {LITERAL(18)}
| "SDL_SCANCODE_P"    {LITERAL(19)}
| "SDL_SCANCODE_Q"    {LITERAL(20)}
| "SDL_SCANCODE_R"    {LITERAL(21)}
| "SDL_SCANCODE_S"    {LITERAL(22)}
| "SDL_SCANCODE_T"    {LITERAL(23)}
| "SDL_SCANCODE_U"    {LITERAL(24)}
| "SDL_SCANCODE_V"    {LITERAL(25)}
| "SDL_SCANCODE_W"    {LITERAL(26)}
| "SDL_SCANCODE_X"    {LITERAL(27)}
| "SDL_SCANCODE_Y"    {LITERAL(28)}
| "SDL_SCANCODE_Z"    {LITERAL(29)}
| "SDL_SCANCODE_1"    {LITERAL(30)}
| "SDL_SCANCODE_2"    {LITERAL(31)}
| "SDL_SCANCODE_3"    {LITERAL(32)}
| "SDL_SCANCODE_4"    {LITERAL(33)}
| "SDL_SCANCODE_5"    {LITERAL(34)}
| "SDL_SCANCODE_6"    {LITERAL(35)}
| "SDL_SCANCODE_7"    {LITERAL(36)}
| "SDL_SCANCODE_8"    {LITERAL(37)}
| "SDL_SCANCODE_9"    {LITERAL(38)}
| "SDL_SCANCODE_0"    {LITERAL(39)}
| digits as lxm { LITERAL(int_of_string lxm) }
| digits '.'  digit* ( ['e' 'E'] ['+' '-']? digits )? as lxm { FLIT(lxm) }
| ['a'-'z']['a'-'z' 'A'-'Z' '0'-'9' '_']*     as lxm { ID(lxm)   }
| ['A'-'Z']['a'-'z' 'A'-'Z' '0'-'9' '_']*             as lxm { SID(lxm) }
| '"'([^'"']*	as	lxm)'"'                              { CLIT(lxm) }
| eof { EOF }
| _ as char { raise (Failure("illegal character " ^ Char.escaped char)) }

and comment = parse
  "*/" { token lexbuf }
| _    { comment lexbuf }

and single_comment = parse
  "\n" { token lexbuf }
| _    { single_comment lexbuf }
