/*
 *
 *  Player struct
 * Authors: Elliott Morelli,
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdbool.h> 
#include "./src/player.h"

typedef struct Player {
   int x;
   int y;
   char *texture;
   int hx;
   int hy;
   int *controls;
   SDL_Texture * text;
} Player;

int getPlayerX(Player *p)
{
  return p->x;
}

int getPlayerY(Player *p)
{
  return p->y;
}

void setPlayerX(Player *p, int x)
{
  p->x = x;
}

void setPlayerY(Player *p, int x)
{
  p->y = x;
}

int getPlayerControl(Player *p, int index)            
{ 
  return p->controls[index];                 
}

void zeroPlayerControls(Player *p)
{
  for (int i = 0; i < 10; i++) {
    p->controls[i] = 0;
  }
}

char *getPlayerText(Player *p) 
{ 
  return p->texture;           
} 
  
int getPlayerHx(Player *p)      
{ 
  return p->hx;                   
} 
  
int getPlayerHy(Player *p)      
{ 
  return p->hy;                   
}

void addPlayerHitBox(Player *p, int x, int y){
  p->hx = x;
  p->hy = y;
}

void changePlayerX(Player *p, int dx)
{
  p->x = p->x + dx;
}

void changePlayerY(Player *p, int dy)
{
  p->y = p->y + dy;
}

bool isKeyPressed(int k){

	if (app.keyboard[k])
	{
		return true;
	} else {
    return false;
  } 
}

void controlPlayer(Player *p, int speed){

  if(isKeyPressed(p->controls[0])){
    changePlayerY(p,-speed);
  }
  if(isKeyPressed(p->controls[1])){
    changePlayerY(p,speed);
  }
  if(isKeyPressed(p->controls[2])){
    changePlayerX(p,-speed);
  }
  if(isKeyPressed(p->controls[3])){
    changePlayerX(p,speed);
  }

}


void initPlayer(Player *p){
  p->text = loadTexture(p->texture);
}

int updateP(Player *p){
  doInput();
	blit(p->text, p->x, p->y);
  return 0;
}

void addPlayerControl(Player *p, int index, int code) {
  p->controls[index] = code;
}

#ifdef BUILD_TEST
int main()
{
  Player p;
  p.x = 1;
  p.y = 2;
  p.texture = "image.png";
  zeroPlayerControl(&p, 0);
  getPlayerX(&p);
}
#endif
