/*
 *  Entity struct
 Authors: Elliott Morelli
 */

#include <stdio.h>
#include <string.h>
#include "./src/entity.h"

typedef struct Entity {
   int x;
   int y;
   char *texture;
   SDL_Texture * text;
   int hx;
   int hy;

} Entity;

int getEntityX(Entity *e)
{
  return e->x;
}

int getEntityY(Entity *e)
{
  return e->y;
}

char *getEntityText(Entity *e)
{
  return e->texture;
}

int getEntityHx(Entity *e)      
{ 
  return e->hx;                 
} 
  
int getEntityHy(Entity *e)      
{
  return e->hy;                 
} 

void setEntityX(Entity *e, int n)
{ 
  e->x = n;
} 
void setEntityY(Entity *e, int n)
{ 
  e->y = n;
} 

void addEntityHitBox(Entity *e, int g, int h)
{
  e->hx = g;
  e->hy = h;
}

void changeEntityX(Entity *e, int dx)
{
  e->x = e->x + dx;
}

void changeEntityY(Entity *e, int dy)
{
  e->y = e->y + dy;
}

void initEntity(Entity *e){
  e->text = loadTexture(e->texture);
}

int updateE(Entity *e){
  doInput();
	blit(e->text, e->x, e->y);
  return 0;

}



#ifdef BUILD_TEST
int main()
{
  Entity e;
  e.x = 1;
  e.y = 2;
  e.texture = "image.png";
  e.hx = 3;
  e.hy = 4;
  getEntityX(e);
}
#endif
