/*
   CompArt used the basic structure of this file:
   
   Copyright (C) 1997-2020 Sam Lantinga <slouken@libsdl.org>

   This software is provided 'as-is', without any express or implied
   warranty.  In no event will the authors be held liable for any damages
   arising from the use of this software.

   Permission is granted to anyone to use this software for any purpose,
   including commercial applications, and to alter it and redistribute it
   freely.

   This file is created by : Nitin Jain (nitin.j4@samsung.com)
*/

#include <stdlib.h>
#include <stdio.h>

#ifdef __EMSCRIPTEN__
#include <emscripten/emscripten.h>
#endif

#include "SDL2/SDL.h"
#include "SDL2_gfxPrimitives.h"

SDL_Window *window;
SDL_Renderer *renderer;
SDL_Surface *surface;
int done;
int r_global = 0;
int g_global = 0;
int b_global = 0;
int a_global = 255;
int r_background = 255;
int g_background = 255;
int b_background = 255;
int fill_status = 1;
int width_global;
int height_global;
void color(int red, int green, int blue)
{
    r_global = red;
    g_global = green;
    b_global = blue;
}

void opacity(int x)
{
    a_global = x;
}

void fill()
{
    fill_status = 1;
}
void noFill()
{
    fill_status = 0;
}

void background(int red, int green, int blue)
{

    SDL_Rect darea;
    /* Get the Size of drawing surface */
    SDL_RenderGetViewport(renderer, &darea);
    SDL_SetRenderDrawColor(renderer, red, green, blue, 0xFF);

    r_background = red;
    g_background = green;
    b_background = blue;
}

void drawRect(int x1, int y1, int x2, int y2)
{
    if (fill_status)
    {
        boxRGBA(renderer, x1, y1, x2, y2, r_global, g_global, b_global, a_global);
    }
    else
    {
        rectangleRGBA(renderer, x1, y1, x2, y2, r_global, g_global, b_global, a_global);
    }
}

void drawLine(int x1, int y1, int x2, int y2)
{
    lineRGBA(renderer, x1, y1, x2, y2, r_global, g_global, b_global, a_global);
}

void drawCircle(int x, int y, int r)
{
    if (fill_status)
    {
        filledCircleRGBA(renderer, x, y, r, r_global, g_global, b_global, a_global);
    }
    else
    {
        circleRGBA(renderer, x, y, r, r_global, g_global, b_global, a_global);
    }
}

void drawTriangle(int x1, int y1, int x2, int y2, int x3, int y3)
{
    if (fill_status)
    {
        filledTrigonRGBA(renderer, x1, y1, x2, y2, x3, y3, r_global, g_global, b_global, a_global);
    }
    else
    {
        trigonRGBA(renderer, x1, y1, x2, y2, x3, y3, r_global, g_global, b_global, a_global);
    }
}

int getMouseX()
{
    int mouseX;
    SDL_GetMouseState(&mouseX, NULL);
    return mouseX;
}
int getMouseY()
{
    int mouseY;
    SDL_GetMouseState(NULL, &mouseY);
    return mouseY;
}

int draw()
{
    /* Got everything on rendering surface,
       now Update the drawing image on window screen */
    SDL_UpdateWindowSurface(window);
    SDL_SetRenderDrawColor(renderer, r_background, g_background, b_background, 0xFF);
    SDL_RenderClear(renderer);

    SDL_Event e;

    while (SDL_PollEvent(&e))
    {

        /* Re-create when window has been resized */
        if ((e.type == SDL_WINDOWEVENT) && (e.window.event == SDL_WINDOWEVENT_SIZE_CHANGED))
        {

            SDL_DestroyRenderer(renderer);

            surface = SDL_GetWindowSurface(window);
            renderer = SDL_CreateSoftwareRenderer(surface);
            /* Clear the rendering surface with the specified color */
            SDL_SetRenderDrawColor(renderer, 0xFF, 0xFF, 0xFF, 0xFF);
            SDL_RenderClear(renderer);
        }

        if (e.type == SDL_QUIT)
        {
            done = 1;
            SDL_Quit();
#ifdef __EMSCRIPTEN__
            emscripten_cancel_main_loop();
#endif
            return 0;
        }

        if ((e.type == SDL_KEYDOWN) && (e.key.keysym.sym == SDLK_ESCAPE))
        {
            done = 1;
            SDL_Quit();
#ifdef __EMSCRIPTEN__
            emscripten_cancel_main_loop();
#endif
            return 0;
        }
    }

    return 0;
}

int createWindow(int width, int height)
{
    int width_global = width;
    int height_global = height;
    /* Enable standard application logging */
    SDL_LogSetPriority(SDL_LOG_CATEGORY_APPLICATION, SDL_LOG_PRIORITY_INFO);

    /* Initialize SDL */
    if (SDL_Init(SDL_INIT_VIDEO) != 0)
    {
        SDL_LogError(SDL_LOG_CATEGORY_APPLICATION, "SDL_Init fail : %s\n", SDL_GetError());
        return 1;
    }

    /* Create window and renderer for given surface */
    window = SDL_CreateWindow("CompArt", SDL_WINDOWPOS_UNDEFINED, SDL_WINDOWPOS_UNDEFINED, width, height, SDL_WINDOW_RESIZABLE);
    if (!window)
    {
        SDL_LogError(SDL_LOG_CATEGORY_APPLICATION, "Window creation fail : %s\n", SDL_GetError());
        return 1;
    }
    surface = SDL_GetWindowSurface(window);
    renderer = SDL_CreateSoftwareRenderer(surface);
    if (!renderer)
    {
        SDL_LogError(SDL_LOG_CATEGORY_APPLICATION, "Render creation for surface fail : %s\n", SDL_GetError());
        return 1;
    }

    /* Clear the rendering surface with the specified color */
    SDL_SetRenderDrawColor(renderer, 0xFF, 0xFF, 0xFF, 0xFF);
    SDL_RenderClear(renderer);

    /* Draw the Image on rendering surface */
    done = 0;
#ifdef __EMSCRIPTEN__
    emscripten_set_main_loop(loop, 0, 1);
#else
#endif

    return 0;
}
