%{ open Ast %}

%token CLASS CONSTRUCTOR NEW DELETE DOT
%token SEMI LPAREN RPAREN LBRACE RBRACE LBRACKET RBRACKET COMMA
%token PLUS MINUS TIMES DIVIDE ASSIGN NOT
%token EQ NEQ LT LEQ GT GEQ TRUE FALSE AND OR
%token RETURN IF ELSE FOR WHILE INT BOOL VOID FLOAT STRING
%token <int> LITERAL
%token <string> STRING_LITERAL
%token <float> FLOAT_LITERAL
%token <string> ID
%token EOF

%nonassoc NOELSE
%nonassoc ELSE
%right RPAREN
%right ASSIGN
%left LBRACKET
%left OR
%left AND
%left EQ NEQ
%left LT GT LEQ GEQ
%left PLUS MINUS
%left TIMES DIVIDE
%right NOT NEG DOT DELETE

%start program
%type <Ast.program> program

%%

program:
    decls EOF { $1 }

decls:
   /* nothing */ { [], [], [] }
 | decls vdecl { let (vdecl,fdecl,cdecl) = $1 in ($2::vdecl,fdecl,cdecl) }
 | decls fdecl { let (vdecl,fdecl,cdecl) = $1 in (vdecl,$2::fdecl,cdecl) }
 | decls cdecl { let (vdecl,fdecl,cdecl) = $1 in (vdecl,fdecl,$2::cdecl) }

cdecl:
        CLASS ID LBRACE cbody RBRACE { {
            cname =  $2;
            cbody =  $4;
        } }

cbody:
        /* nothing */ { {
            fields = [];
            methods = [];
            constructors = [];
        } }
    |   cbody vdecl { {
            fields = $2 :: $1.fields;
            methods = $1.methods;
            constructors = $1.constructors
        } }
    |   cbody fdecl { {
            fields = $1.fields;
            methods = $2 :: $1.methods;
            constructors = $1.constructors
        } }
    |   cbody constructor { {
            fields = $1.fields;
            methods = $1.methods;
            constructors = $2 :: $1.constructors
        } }

constructor:
        CONSTRUCTOR LPAREN formals_opt RPAREN LBRACE vdecl_list stmt_list RBRACE { {
            typ = Constructortyp;
            fname = "constructor";
            formals = $3;
            locals = List.rev $6;
            body = List.rev $7;
        } } 

fdecl:
    typ ID LPAREN formals_opt RPAREN LBRACE vdecl_list stmt_list RBRACE { {
        typ = $1;
        fname = $2;
        formals = $4;
        locals = List.rev $7;
        body = List.rev $8 
    } }

formals_opt:
    /* nothing */ { [] }
  | formal_list   { List.rev $1 }

formal_list:
    typ ID                   { [($1,$2)] }
  | formal_list COMMA typ ID { ($3,$4) :: $1 }

obj:
    CLASS ID { Object($2) }

primitive:
    INT { Int }
  | BOOL { Bool }
  | VOID { Void }
  | STRING { String }
  | FLOAT { Float }

arraytype:
    primitive LBRACKET RBRACKET { Arraytype($1) }
    
typ:
    primitive { $1 }
  | obj { $1 }
  | arraytype { $1 }

vdecl_list:
    /* nothing */    { [] }
  | vdecl_list vdecl { $2 :: $1 }

vdecl:
   typ ID SEMI { ($1, $2) }

stmt_list:
    /* nothing */  { [] }
  | stmt_list stmt { $2 :: $1 }

stmt:
    expr SEMI { Expr $1 }
  | RETURN SEMI { Return Noexpr }
  | RETURN expr SEMI { Return $2 }
  | LBRACE stmt_list RBRACE { Block(List.rev $2) }
  | IF LPAREN expr RPAREN stmt %prec NOELSE { If($3, $5, Block([])) }
  | IF LPAREN expr RPAREN stmt ELSE stmt    { If($3, $5, $7) }
  | FOR LPAREN expr_opt SEMI expr SEMI expr_opt RPAREN stmt { For($3, $5, $7, $9) }
  | WHILE LPAREN expr RPAREN stmt { While($3, $5) }

expr_opt:
    /* nothing */ { Noexpr }
  | expr          { $1 }

expr:
    LITERAL          { Literal($1) }
  | STRING_LITERAL   { StringLit($1) }
  | FLOAT_LITERAL    { FloatLit($1) }
  | TRUE             { BoolLit(true) }
  | FALSE            { BoolLit(false) }
  | ID               { Id($1) } 
  | LPAREN typ RPAREN expr { Cast( $2,$4) }
  | expr PLUS   expr { Binop($1, Add,   $3) }
  | expr MINUS  expr { Binop($1, Sub,   $3) }
  | expr TIMES  expr { Binop($1, Mult,  $3) }
  | expr DIVIDE expr { Binop($1, Div,   $3) }
  | expr EQ     expr { Binop($1, Equal, $3) }
  | expr NEQ    expr { Binop($1, Neq,   $3) }
  | expr LT     expr { Binop($1, Less,  $3) }
  | expr LEQ    expr { Binop($1, Leq,   $3) }
  | expr GT     expr { Binop($1, Greater, $3) }
  | expr GEQ    expr { Binop($1, Geq,   $3) }
  | expr AND    expr { Binop($1, And,   $3) }
  | expr OR     expr { Binop($1, Or,    $3) }
  | expr DOT    expr { ObjAccess($1, $3) }
  | MINUS expr %prec NEG { Unop(Neg, $2) }
  | NOT expr         { Unop(Not, $2) }
  | expr ASSIGN expr   { Assign($1, $3) }
  | ID LPAREN actuals_opt RPAREN { Call($1, $3) }
  | LPAREN expr RPAREN { $2 }
  | NEW ID LPAREN actuals_opt RPAREN { ObjCreate($2,$4) }
  | NEW primitive LBRACKET LITERAL RBRACKET { ArrayCreate($2, $4) } 
  | expr LBRACKET LITERAL RBRACKET { ArrayAccess($1, $3) } 
  | DELETE expr      { Delete($2) }

actuals_opt:
    /* nothing */ { [] }
  | actuals_list  { List.rev $1 }

actuals_list:
    expr                    { [$1] }
  | actuals_list COMMA expr { $3 :: $1 }
