open Sast
(* Top-level of the MicroC compiler: scan & parse the input,
   check the resulting AST, generate LLVM IR, and dump the module *)

type action = Ast | Sast | LLVM_IR | Compile

let _ =
  let action = if Array.length Sys.argv > 1 then
    List.assoc Sys.argv.(1) [ ("-a", Ast);	(* Print the AST only *)
                  ("-s", Sast); (* Print the SAST only *)
			      ("-l", LLVM_IR);  (* Generate LLVM, don't check *)
			      ("-c", Compile) ] (* Generate, check LLVM IR *)
  else Compile in
  let lexbuf = Lexing.from_channel stdin in
  let ast = Parser.program Scanner.token lexbuf in
  let sast = Semant.analyze ast in  
  let (globals, function_decls, class_decls, main_decl, builtin_decls) = sast in
  let program = {
		global_vars = globals;
		functions = function_decls;
    classes = class_decls;
    main = main_decl;
    builtins = builtin_decls;
	} 
  in
  match action with
    Ast -> print_string (Ast.string_of_program ast)
  | Sast -> print_string (Sast.string_of_s_program sast)
  | LLVM_IR -> print_string (Llvm.string_of_llmodule (Codegen.codegen_sprogram program))
  | Compile -> let m = Codegen.codegen_sprogram program in
    Llvm_analysis.assert_valid_module m;
    print_string (Llvm.string_of_llmodule m)

