/* Ocamlyacc parser for CFlat */

%{
open Ast
%}

%token SEMI LPAREN RPAREN LBRACE RBRACE COMMA PLUS MINUS TIMES DIVIDE ASSIGN
%token LBRACK RBRACK
%token TONEACCESS OCTAVEACCESS RHYTHMACCESS
%token TONESET OCTAVESET RHYTHMSET
%token TONERAISE OCTAVERAISE OCTAVELOWER
%token MAKE
%token NOT EQ NEQ LT LEQ GT GEQ AND OR
%token RETURN IF ELSE FOR WHILE 
%token INT BOOL FLOAT VOID NOTE STRING TONE OCTAVE RHYTHM
%token <int> LITERAL OLIT
%token <bool> BLIT
%token <string> ID FLIT STRLIT TLIT RLIT
%token EOF

%start program
%type <Ast.program> program

%nonassoc NOELSE
%nonassoc ELSE
%right ASSIGN
%left OR
%left AND
%left EQ NEQ
%left LT GT LEQ GEQ
%left PLUS MINUS
%left TIMES DIVIDE
%right NOT
%right TONERAISE OCTAVERAISE OCTAVELOWER
%right TONESET OCTAVESET RHYTHMSET
%right TONEACCESS OCTAVEACCESS RHYTHMACCESS

%%

program:
  decls EOF { $1 }

decls:
   /* nothing */ { ([], [])               }
 | decls vdecl { (($2 :: fst $1), snd $1) }
 | decls fdecl { (fst $1, ($2 :: snd $1)) }

fdecl:
   typ ID LPAREN formals_opt RPAREN LBRACE vdecl_list stmt_list RBRACE
     { { typ = $1;
	 fname = $2;
	 formals = List.rev $4;
	 locals = List.rev $7;
	 body = List.rev $8 } }

formals_opt:
    /* nothing */ { [] }
  | formal_list   { $1 }

formal_list:
    typ ID                   { [($1,$2)]     }
  | formal_list COMMA typ ID { ($3,$4) :: $1 }

typ:
    primitive_typ { PrimitiveType($1) }
  | array_typ     { $1 }    

primitive_typ:
    INT     { Int   }
  | BOOL    { Bool  }
  | FLOAT   { Float }
  | VOID    { Void  }
  | NOTE    { Note  }
  | TONE    { Tone  }
  | OCTAVE  { Octave }
  | RHYTHM  { Rhythm }
  | STRING  { String }

array_typ:
  primitive_typ LBRACK RBRACK { ArrayType($1) }

literal:
    LITERAL          { Literal($1)            }
  | FLIT	           { Fliteral($1)           }
  | BLIT             { BoolLit($1)            }
  | STRLIT           { StrLit($1)             }
  | notelit          { $1                     }
  | tlit             { $1                     }
  | olit             { $1                     }
  | rlit             { $1                     }

tlit:
    TLIT             { ToneLit($1)            }

olit:
    OLIT             { OctaveLit($1)          }

rlit:
    RLIT             { RhythmLit($1)          }

notelit:
    LPAREN tlit olit rlit RPAREN    { NoteLit($2, $3, $4)}
    /* allow for default values? */

vdecl_list:
    /* nothing */    { [] }
  | vdecl_list vdecl { $2 :: $1 }

vdecl:
   typ ID SEMI { ($1, $2) }

stmt_list:
    /* nothing */  { [] }
  | stmt_list stmt { $2 :: $1 }

stmt:
    expr SEMI                               { Expr $1               }
  | RETURN expr_opt SEMI                    { Return $2             }
  | LBRACE stmt_list RBRACE                 { Block(List.rev $2)    }
  | IF LPAREN expr RPAREN stmt %prec NOELSE { If($3, $5, Block([])) }
  | IF LPAREN expr RPAREN stmt ELSE stmt    { If($3, $5, $7)        }
  | FOR LPAREN expr_opt SEMI expr SEMI expr_opt RPAREN stmt
                                            { For($3, $5, $7, $9)   }
  | WHILE LPAREN expr RPAREN stmt           { While($3, $5)         }

expr_opt:
    /* nothing */ { Noexpr }
  | expr          { $1 }

expr:
    literal          { $1 }
  | ID               { Id($1) }
  | ID ASSIGN expr   { Assign($1, $3)         }
  | ID LPAREN args_opt RPAREN { Call($1, $3)  }
  | ID TONEACCESS    { ToneAccess($1)         }
  | ID OCTAVEACCESS  { OctaveAccess($1)       }
  | ID RHYTHMACCESS  { RhythmAccess($1)       }
  | ID TONESET LPAREN expr RPAREN          { ToneSet($1, $4)           }
  | ID OCTAVESET LPAREN expr RPAREN        { OctaveSet($1, $4)         }
  | ID RHYTHMSET LPAREN expr RPAREN        { RhythmSet($1, $4)         }
  | ID TONERAISE LPAREN expr RPAREN        { ToneRaise($1, $4)         }
  | ID OCTAVERAISE LPAREN expr RPAREN      { OctaveRaise($1, $4)       }
  | ID OCTAVELOWER LPAREN expr RPAREN      { OctaveLower($1, $4)       }
  | LPAREN expr RPAREN { $2                   }
  | expr PLUS   expr { Binop($1, Add,   $3)   }
  | expr MINUS  expr { Binop($1, Sub,   $3)   }
  | expr TIMES  expr { Binop($1, Mult,  $3)   }
  | expr DIVIDE expr { Binop($1, Div,   $3)   }
  | expr EQ     expr { Binop($1, Equal, $3)   }
  | expr NEQ    expr { Binop($1, Neq,   $3)   }
  | expr LT     expr { Binop($1, Less,  $3)   }
  | expr LEQ    expr { Binop($1, Leq,   $3)   }
  | expr GT     expr { Binop($1, Greater, $3) }
  | expr GEQ    expr { Binop($1, Geq,   $3)   }
  | expr AND    expr { Binop($1, And,   $3)   }
  | expr OR     expr { Binop($1, Or,    $3)   }
  | MINUS expr %prec NOT { Unop(Neg, $2)      }
  | NOT expr         { Unop(Not, $2)          }
  | MAKE LPAREN primitive_typ COMMA expr RPAREN   { MakeArray($3, $5) }
  | ID LBRACK expr RBRACK ASSIGN expr             { ArrayAssign($1, $3, $6) }
  | ID LBRACK expr RBRACK                 { ArrayAccess($1, $3) }

args_opt:
    /* nothing */ { [] }
  | args_list  { List.rev $1 }

args_list:
    expr                    { [$1] }
  | args_list COMMA expr { $3 :: $1 }
