#!/bin/sh

# Regression testing script for Arbol
# Step through a list of files
#  Compile, run, and check the output of each expected-to-work test
#  Compile and check the error of each expected-to-fail test

#echo "No tests yet. Add more tests here"
#exit 0


# Path to the LLVM interpreter
LLI="lli"
# LLI="/usr/local/opt/llvm@11/bin/lli"

# Path to the LLVM compiler
# LLC="/usr/local/opt/llvm@11/bin/llc"
LLC="llc"

# Path to the C compiler
CC="/usr/bin/cc"

# Path to the arbol compiler.  Usually "./arbol"
# Try "_build/arbol" if ocamlbuild was unable to create a symbolic link.
ARBOL="./arbol"

globallog=testall.log
rm -f $globallog
error=0
globalerror=0

keep=0

Usage() {
    echo "Usage: testall.sh [options] [.mc files]"
    echo "-k    Keep intermediate files"
    echo "-h    Print this help"
    exit 1
}

SignalError() {
    if [ $error -eq 0 ] ; then
    echo "FAILED"
    error=1
    fi
    echo "  $1"
}

# Run <args>
# Report the command, run it, and report any errors
Run() {
    echo $* 1>&2
    eval $* || {
    SignalError "$1 failed on $*"
    return 1
    }
}

# RunFail <args>
# Report the command, run it, and expect an error
RunFail() {
    echo $* 1>&2
    eval $* && {
    SignalError "failed: $* did not report an error"
    return 1
    }
    return 0
}
basename="test"
$ARBOL -c $1 > ${basename}.ll
$LLC -relocation-model=pic ${basename}.ll > ${basename}.s
$CC -c -DBUILD_TEST print.c
$CC -o ${basename}.exe ${basename}.s print.o
./${basename}.exe