/* Compile -- 
 * ocamlyacc -v parser.mly)
 */

/*
 *
 * ARBOL Parser
 *
 */

%{
  open Ast;; 
%}

/* Punctuation Tokens */
%token LPAREN RPAREN LBRACE RBRACE
%token SEMI COMMA
%token LCHILD RCHILD DEREF NODE_INIT NODE_ASSIGN GET_CHILD_L GET_CHILD_R
%token EOF
/* LBRACK RBRACK */

/* Keywords */
%token FUNCTION RETURN
%token IF ELSE FOR WHILE CONTINUE BREAK 
%token INT FLOAT BOOL CHAR VOID STRING
/* Added for Array inplementation */
// %token ARRAY NODE

/* Arithmetic, Assignment, Relational, and Logical Operators */
%token PLUS MINUS MOD TIMES DIVIDE
%token ASSIGN
%token EQUALS NOT_EQUALS GREATER_THAN GREATER_THAN_EQUALS LESS_THAN LESS_THAN_EQUALS
%token AND OR NOT

/* Literals */
%token <bool> BOOL_LIT
%token <string> ID
%token <int> INT_LIT
%token <string> FLOAT_LIT
%token <char> CHAR_LIT
%token <string> STRING_LIT

%start entry
%type <Ast.program> entry
%type <Ast.program> program
%type <Ast.expr> expr
%type <Ast.vtype> vtype

/* Precedence and Associativity */
%nonassoc NOELSE
%nonassoc ELSE
%nonassoc LPAREN
%right ASSIGN NODE_ASSIGN
%left OR 
%left AND 
%left EQUALS NOT_EQUALS
%left GREATER_THAN GREATER_THAN_EQUALS LESS_THAN LESS_THAN_EQUALS
%left PLUS MINUS
%left TIMES DIVIDE MOD
%right NOT 
%left GET_CHILD_L GET_CHILD_R

/* UNder NOT: %left DEREF */
%%

entry:
	program EOF 				{$1}

program:
	  /* nothing */				{[], []} 
	| program vdecl SEMI 	 		{($2 :: fst $1), snd $1}
	| program function_dec			{fst $1, ($2 :: snd $1)}

/*
 * STATEMENTS
 */

statement_list:
	/* nothing */ 				{[]}
	| statement_list statement 	{$2::$1}

statement:
	  expr SEMI 			        	{Expr($1)}
	| if_else_statement 				{$1}
	| iteration_statement 				{$1}
	| BREAK SEMI 						{Break}
	| CONTINUE SEMI 	 				{Continue}
	| RETURN expr_optional SEMI 	 	{Return($2)}
	| LBRACE statement_list RBRACE 		{Block(List.rev $2)} /* Check */
	| node_declare_child SEMI 			{$1}
	/*| assign_statement 					{$1}*/
	| var_initialize SEMI 	 				{Variable($1)}

if_else_statement:
	  IF LPAREN expr RPAREN statement %prec NOELSE{ If($3, $5, Block([]))}
	| IF LPAREN expr RPAREN statement ELSE statement {If($3, $5, $7)}

iteration_statement:
	  FOR LPAREN expr_optional SEMI expr_optional SEMI expr_optional RPAREN statement { For($3, $5, $7, $9)}
	| WHILE LPAREN expr_optional RPAREN statement { While($3, $5)}

/*assign_statement:
      ID ASSIGN expr SEMI { Assign($1, $3) }
    | ID LBRACK expr RBRACK ASSIGN expr SEMI { SetElementAssign($1, $3, $6)} /* Add this rule to AST */

 /*array_assign_statement:
 	  var_type LBRACK expr RBRACK ASSIGN expr SEMI {ArrayAssign($1, $3, $6)}
 	| var_type LBRACK RBRACK ASSIGN expr SEMI {ArrayAssign($1, Noexpr, $5)} */

/* Function Declaration: */
function_dec:
	  FUNCTION vtype ID LPAREN params_optional RPAREN LBRACE statement_list RBRACE {
			{	rtype = $2; 
				fname = $3; 
				args_list = $5;
				body = List.rev $8;
			}}

/* Formal Args: */
params_optional:
	  {[]} //nothing
	| params 		{List.rev $1}

params:
	  vtype ID 				{[{
											v_type = $1; 
											v_name = $2; 
											v_val = Noexpr;
											node_val = false;
										}]} 
	| params COMMA vtype ID 	{{
											v_type = $3; 
											v_name = $4; 
											v_val = Noexpr;
											node_val = false;
										} :: $1}


/*
 * EXPRESSIONS
 */
expr_optional:
	/* nothing */			{Noexpr}
	| expr 			     	{$1} /* Just expr ? */

expr:
	  literal 						 {$1}
	| ID 							 {Id($1)}
	| LPAREN expr RPAREN 			 {$2} /* new */
	| expr PLUS expr 				 {Binop($1, Plus, $3)}
	| expr MINUS expr 				 {Binop($1, Minus, $3)}
	| expr TIMES expr 				 {Binop($1, Times, $3)}
	| expr DIVIDE expr 				 {Binop($1, Divide, $3)}
	| expr MOD expr 				 {Binop($1, Mod, $3)}
	| expr EQUALS expr 				 {Binop($1, Equals, $3)}
	| expr NOT_EQUALS expr 			 {Binop($1, Not_Equals, $3)}
	| expr GREATER_THAN expr 		 {Binop($1, Greater, $3)}
	| expr GREATER_THAN_EQUALS expr  {Binop($1, Greater_Eq, $3)}
	| expr LESS_THAN expr  			 {Binop($1, Less, $3)}
	| expr LESS_THAN_EQUALS expr 	 {Binop($1, Less_Eq, $3)}				
	| expr AND expr 				 {Binop($1, And, $3)}
	| expr OR expr 					 {Binop($1, Or, $3)}
	| NOT expr 						 {Unop(Not,$2)}
	| MINUS expr %prec NOT 			 {Unop(Neg, $2)} /* new */
	| node_ops						 			{$1}
	| ID ASSIGN expr    			 {Assign($1, $3)} /* new */
	| ID LPAREN args_optional RPAREN {Call($1, $3)} 


args_optional:
    /* nothing */ { [] }
  | args_list  { List.rev $1 }

args_list:
    expr                    { [$1] }
  | args_list COMMA expr { $3 :: $1 }

/*
 * TREE SYNTAX
 */

node_declare_child:
	  ID LCHILD expr 	 		   {Node_child($1, Set_left_child, $3)} 
	| ID RCHILD expr 			   {Node_child($1, Set_right_child, $3)} 

node_ops:
	  DEREF ID 				    {Nodeop(Dref, $2)}
	| GET_CHILD_R ID 		 	{Nodeop(Get_right_child, $2)}
	| GET_CHILD_L ID			{Nodeop(Get_left_child, $2)}
	| ID NODE_ASSIGN expr 		{Node_assign($1, $3)}

/*
 * VARIABLES 
 */
vtype:
	  literal_type			{$1}
	| vtype NODE_INIT {Node($1)}


literal_type:
	  INT 							{Int}
	| FLOAT 						{Float}
	| BOOL 							{Bool}
	| CHAR 							{Char}
	| VOID 							{Void}
	| STRING						{String}

var_initialize:
	  vdecl							{$1}
	| vtype ID ASSIGN expr {
		{ v_type = $1;
		  v_name = $2; 
		  v_val = $4;
		  node_val = false;
		  }}
	| vtype ID NODE_ASSIGN expr { (* Creates node, deref, and node_assign to val (i.e. 3) *)
		{ v_type = $1; 
		  v_name = $2; 
		  v_val = $4;
		  node_val = true;
		 }}

vdecl:
		vtype ID	 	 	{  
									if ($1 == Void) then 
										raise Variable_of_void
									else 
									{
										v_type = $1; 
										v_name = $2; 
										v_val = Noexpr;
										node_val = false;
										}  
								}

literal:
	  INT_LIT						{Int_lit($1)}
	| FLOAT_LIT 					{Float_lit($1)}
	| BOOL_LIT						{Bool_lit($1)}
	| CHAR_LIT 						{Char_lit($1)}
	| STRING_LIT					{String_lit($1)} /* Added */
