#!/bin/bash

# author: Crystal Ren
set -e

if [ -z "$1" ]
  then
    echo "Usage: ./run.sh <name_of_file.mql>"
    exit 1
fi
f=$1
n=${f%.mql*}
cat $f | ./mql.native > "$n.ll"
llc -relocation-model=pic "$n.ll"
cc -o "$n" "$n.s" "buildin.o" "-lm"
"./$n"
rm $n.ll $n.s $n
